/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.parser.ParameterDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ReferenceDefinition;
import org.eclipse.sensinact.gateway.generic.parser.SignatureDefinition;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.eclipse.sensinact.gateway.generic.parser.XmlEscaped;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.xml.sax.Attributes;

@XmlAttributes(value={@XmlAttribute(attribute="type", field="type")})
@XmlEscaped(value={"references"})
public class MethodDefinition
extends XmlModelParsingContext
implements Iterable<SignatureDefinition> {
    private List<SignatureDefinition> signatureDefinitions = new ArrayList<SignatureDefinition>();
    private AccessMethod.Type type;
    SignatureDefinition current = null;

    public MethodDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    public void closeParameters() {
        int index;
        if (this.current == null) {
            this.current = new SignatureDefinition(this.type);
        }
        for (index = this.signatureDefinitions.size() - 1; index >= 0 && this.current.compareTo(this.signatureDefinitions.get(index)) < 0; --index) {
        }
        this.signatureDefinitions.add(index + 1, this.current);
        this.current = null;
    }

    public void addParameter(ParameterDefinition parameterDefinition) {
        if (parameterDefinition == null) {
            return;
        }
        if (this.current == null) {
            this.current = new SignatureDefinition(this.type);
        }
        this.current.addParameter(parameterDefinition);
    }

    @Override
    public Iterator<SignatureDefinition> iterator() {
        return this.signatureDefinitions.iterator();
    }

    public void addReferenceDefinition(ReferenceDefinition referenceDefinition) {
        if (this.current == null) {
            this.current = new SignatureDefinition(this.type);
        }
        this.current.addReferenceDefinition(referenceDefinition);
    }

    public AccessMethod.Type getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = AccessMethod.Type.valueOf((String)type);
    }

    @Override
    public void end() {
        this.closeParameters();
        super.end();
    }

    public void parameterStart(Attributes atts) {
        ParameterDefinition parameterDefinition = new ParameterDefinition(this.mediator, atts);
        this.addParameter(parameterDefinition);
        super.setNext(parameterDefinition);
    }

    public void referenceStart(Attributes atts) {
        ReferenceDefinition referenceDefinition = new ReferenceDefinition(this.mediator, atts);
        this.addReferenceDefinition(referenceDefinition);
        super.setNext(referenceDefinition);
    }
}

