/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectedService
implements InvocationHandler,
ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(InjectedService.class);
    private final Class<?> type;
    private final String filter;
    private final Mediator mediator;
    private ServiceReference<?> reference;

    InjectedService(Mediator mediator, Class<?> type, String filter) throws InvalidSyntaxException {
        this.mediator = mediator;
        this.type = type;
        this.filter = filter;
        String objectClassFilter = "(" + "objectClass" + "=" + type.getCanonicalName() + ")";
        String propertiesFilter = filter == null ? null : (filter.startsWith("(") ? "" : "(") + filter + (filter.endsWith(")") ? "" : ")");
        this.mediator.getContext().addServiceListener((ServiceListener)this, (propertiesFilter != null ? "(&" : "") + objectClassFilter + (propertiesFilter != null ? propertiesFilter : "") + (propertiesFilter != null ? ")" : ""));
        this.searchReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        Object result = null;
        Object service = null;
        if (this.reference != null && (service = this.mediator.getContext().getService(this.reference)) != null) {
            try {
                result = method.invoke(service, parameters);
            }
            finally {
                this.mediator.getContext().ungetService(this.reference);
            }
        }
        if (result == null && method.getReturnType().isPrimitive() && method.getReturnType() != Void.TYPE) {
            throw new NullPointerException();
        }
        return result;
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                if (this.reference != null) break;
                this.reference = event.getServiceReference();
                break;
            }
            case 4: {
                if (!event.getServiceReference().equals(this.reference)) break;
                this.reference = null;
                this.searchReference();
            }
        }
    }

    private void searchReference() {
        int index;
        int length;
        ServiceReference[] references;
        block4: {
            references = null;
            try {
                references = this.mediator.getContext().getServiceReferences(this.type.getCanonicalName(), this.filter);
            }
            catch (InvalidSyntaxException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        int n = length = references == null ? 0 : references.length;
        for (index = 0; index < length && this.mediator.getContext().getService(references[index]) == null; ++index) {
        }
        if (index < length) {
            this.mediator.getContext().ungetService(references[index]);
            this.reference = references[index];
        }
    }

    protected boolean exists() {
        return this.reference != null;
    }

    protected void delete() {
        this.mediator.getContext().removeServiceListener((ServiceListener)this);
        this.reference = null;
    }
}

