/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ConnectorCustomizer;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtServiceProviderImpl;
import org.eclipse.sensinact.gateway.generic.packet.DefaultPacketReaderFactory;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.generic.packet.PacketReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectorCustomizer<P extends Packet>
implements ConnectorCustomizer<P> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConnectorCustomizer.class);
    private List<PacketReaderFactory> factories;
    private ExtModelConfiguration ExtModelConfiguration;

    public DefaultConnectorCustomizer(Mediator mediator, ExtModelConfiguration extModelConfiguration) {
        this.ExtModelConfiguration = extModelConfiguration;
        this.factories = new ArrayList<PacketReaderFactory>();
        ServiceLoader<PacketReaderFactory> loader = ServiceLoader.load(PacketReaderFactory.class, mediator.getClassLoader());
        for (PacketReaderFactory factory : loader) {
            if (extModelConfiguration.getPacketType() != null && !factory.handle(extModelConfiguration.getPacketType())) continue;
            this.factories.add(factory);
        }
        if (this.factories.isEmpty()) {
            this.factories.add(new DefaultPacketReaderFactory(mediator, extModelConfiguration));
        }
    }

    @Override
    public boolean preProcessing(P packet) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pre-processing done");
        }
        return true;
    }

    @Override
    public void postProcessing(ExtServiceProviderImpl processor, PacketReader<P> packet) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("post-processing done");
        }
    }

    @Override
    public PacketReader<P> newPacketReader(P packet) throws InvalidPacketException {
        PacketReader<P> reader = null;
        for (PacketReaderFactory factory : this.factories) {
            if (!factory.handle(packet.getClass())) continue;
            reader = factory.newInstance(this.ExtModelConfiguration, packet);
            break;
        }
        return reader;
    }
}

