/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ManagedProtocolStackEndpointFactory;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpointConfigurator;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedBasisActivator<M extends Mediator>
extends AbstractActivator<M> {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedBasisActivator.class);
    private ManagedProtocolStackEndpointFactory factory;

    protected abstract String name();

    protected abstract ProtocolStackEndpointConfigurator configurator();

    public void doStart() throws Exception {
        LOG.info("Registering ManagedProtocolStackEndpointFactory");
        this.factory = new ManagedProtocolStackEndpointFactory(this.mediator, this.name()){

            @Override
            protected ProtocolStackEndpointConfigurator configurator() {
                return ManagedBasisActivator.this.configurator();
            }
        };
        this.mediator.register((Object)this.factory, ManagedServiceFactory.class, (Dictionary)new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("service.pid", ManagedBasisActivator.this.name());
            }
        });
    }

    public void doStop() throws Exception {
        LOG.info("Unregistering ManagedProtocolStackEndpointFactory");
        if (this.factory != null) {
            this.factory.stop();
        }
    }
}

