/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.sensorthings.sensing.dto.Id;
import org.eclipse.sensinact.sensorthings.sensing.rest.ExpansionSettings;

public final class ExpansionSettingsImpl
implements ExpansionSettings {
    private final Map<String, ExpansionSettingsImpl> configuredExpansions = new HashMap<String, ExpansionSettingsImpl>();
    private final Map<String, Map<String, Object>> expandedValues = new HashMap<String, Map<String, Object>>();

    private ExpansionSettingsImpl() {
    }

    public ExpansionSettingsImpl(Stream<String> expansion) {
        expansion.forEach(this::addRequestedExpansion);
    }

    private void addRequestedExpansion(String expansion) {
        ExpansionSettingsImpl settings = this;
        for (String s : expansion.split("/")) {
            settings = settings.configuredExpansions.computeIfAbsent(s, x -> new ExpansionSettingsImpl());
        }
    }

    @Override
    public ExpansionSettings getExpansionSettings(String pathSegment) {
        return this.configuredExpansions.get(pathSegment);
    }

    @Override
    public boolean shouldExpand(String pathSegment, Id context) {
        return this.configuredExpansions.containsKey(pathSegment) && Optional.ofNullable(this.expandedValues.get(pathSegment)).map(m -> m.get(this.toStringId(context))).isEmpty();
    }

    @Override
    public void addExpansion(String pathSegment, Id context, Object expansion) {
        if (!this.shouldExpand(pathSegment, context)) {
            throw new IllegalArgumentException("The path " + pathSegment + " is not expandable");
        }
        this.expandedValues.computeIfAbsent(pathSegment, x -> new HashMap()).put(this.toStringId(context), expansion);
    }

    private String toStringId(Id context) {
        return String.valueOf(context.id);
    }

    public boolean isExpanded(String pathSegment) {
        return this.expandedValues.containsKey(pathSegment);
    }

    public Object getExpanded(String pathSegment) {
        return this.expandedValues.get(pathSegment);
    }

    public boolean isEmpty() {
        return this.configuredExpansions.isEmpty();
    }

    private Map<String, Object> getExpansionsFor(JsonNode context) {
        if (context.hasNonNull("@iot.id")) {
            String id = context.get("@iot.id").asText();
            return this.expandedValues.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey(id)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).get(id)));
        }
        return Map.of();
    }

    public JsonNode processExpansions(ObjectMapper mapper, Object object) {
        JsonNode node = object instanceof JsonNode ? (JsonNode)object : mapper.valueToTree(object);
        this.processExpansions(mapper, node);
        return node;
    }

    private void processExpansions(ObjectMapper mapper, JsonNode node) {
        if (node.getNodeType() == JsonNodeType.OBJECT) {
            ObjectNode on = (ObjectNode)node;
            if (this.isResultList((JsonNode)on)) {
                this.processExpansions(mapper, on.get("value"));
                return;
            }
            for (Map.Entry<String, Object> e : this.getExpansionsFor((JsonNode)on).entrySet()) {
                String field = e.getKey();
                JsonNode expansion = this.configuredExpansions.get(field).processExpansions(mapper, e.getValue());
                String linkField = field + "@iot.navigationLink";
                JsonNode link = on.remove(linkField);
                if (this.isResultList(expansion)) {
                    JsonNode value = expansion.get("value");
                    JsonNode count = expansion.get("@iot.count");
                    if (count != null && count.isNumber()) {
                        on.set(field + "@iot.count", count);
                        if (value.isArray() && count.asInt() > value.size()) {
                            on.put(field + "@iot.nextLink", link.asText() + "$skip=" + value.size());
                        }
                    }
                    on.set(field, value);
                    continue;
                }
                on.set(field, expansion);
            }
        } else if (node.getNodeType() == JsonNodeType.ARRAY) {
            node.forEach(n -> this.processExpansions(mapper, (JsonNode)n));
        }
    }

    private boolean isResultList(JsonNode json) {
        JsonNode node;
        if (json.has("value") && ((node = json.get("value")).isArray() || node.isNull())) {
            Set<String> permittedKeys = Set.of("value", "@iot.count", "@iot.nextLink");
            return node.properties().stream().noneMatch(e -> !permittedKeys.contains(e.getKey()));
        }
        return false;
    }
}

