/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.util.stream.Collectors;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Self;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.RefFilter;

@RefFilter
public class RefFilterImpl
implements WriterInterceptor {
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        Object entity = context.getEntity();
        if (entity instanceof ResultList) {
            ResultList resultList = (ResultList)entity;
            ResultList newEntity = new ResultList();
            newEntity.value = resultList.value.stream().map(r -> {
                Self s = new Self();
                s.selfLink = r.selfLink;
                return s;
            }).collect(Collectors.toList());
            newEntity.count = resultList.count;
            newEntity.nextLink = resultList.nextLink;
            context.setEntity((Object)newEntity);
        } else if (entity instanceof Self) {
            Self self = (Self)entity;
            Self newEntity = new Self();
            newEntity.selfLink = self.selfLink;
            context.setEntity((Object)newEntity);
        } else if (entity instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)entity;
            if (!node.isArray()) {
                node.retain(new String[]{"@iot.selfLink"});
            } else {
                ArrayNode array = (ArrayNode)entity;
                for (int i = 0; i < array.size(); ++i) {
                    JsonNode jsonNode = array.get(i);
                    array.set(i, ((ObjectNode)jsonNode).get("@iot.selfLink"));
                }
            }
        } else if (entity != null) {
            throw new InternalServerErrorException("The entity " + entity + " does not have a reference");
        }
        context.proceed();
    }
}

