/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;

@Priority(value=5001)
public class SelectFilter
implements ContainerResponseFilter {
    @Context
    Providers providers;

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        List fields = (List)requestContext.getUriInfo().getQueryParameters().getOrDefault((Object)"$select", List.of());
        if (fields.isEmpty()) {
            return;
        }
        fields = fields.stream().flatMap(s -> Arrays.stream(s.split(","))).collect(Collectors.toList());
        Object entity = responseContext.getEntity();
        JsonNode json = this.getMapper().valueToTree(entity);
        if (entity instanceof ResultList) {
            ArrayNode values = (ArrayNode)json.get("value");
            for (JsonNode jn : values) {
                if (!jn.isObject()) continue;
                ObjectNode on = (ObjectNode)jn;
                on.retain(fields);
            }
        } else if (json.isObject()) {
            ObjectNode on = (ObjectNode)json;
            on.retain(fields);
        }
        responseContext.setEntity((Object)json);
    }
}

