/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;

@Priority(value=4001)
public class TopFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String TOP_PROP = "org.eclipse.sensinact.sensorthings.sensing.rest.top";
    @Context
    ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Integer top = (Integer)requestContext.getProperty(TOP_PROP);
        if (top == null) {
            return;
        }
        Object entity = responseContext.getEntity();
        if (entity instanceof ResultList) {
            ResultList resultList = (ResultList)entity;
            int size = resultList.value.size();
            resultList.value = resultList.value.subList(0, Math.min(top, size));
            Integer skip = (Integer)requestContext.getProperty("org.eclipse.sensinact.sensorthings.sensing.rest.skip");
            Integer nextSkip = skip == null ? top : top + skip;
            if (top < size) {
                resultList.nextLink = requestContext.getUriInfo().getRequestUriBuilder().replaceQueryParam("$skip", new Object[]{nextSkip}).build(new Object[0]).toString();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filter(ContainerRequestContext requestContext) throws IOException {
        int top = 0;
        PaginationLimit paginationLimit = this.resourceInfo.getResourceMethod().getAnnotation(PaginationLimit.class);
        List list = (List)requestContext.getUriInfo().getQueryParameters().getOrDefault((Object)"$top", List.of());
        if (list.size() > 1) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Only one $top parameter may be provided").build());
            return;
        }
        if (list.isEmpty()) {
            if (paginationLimit == null) return;
            top = paginationLimit.value();
        } else {
            String s = (String)list.get(0);
            try {
                top = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The $top parameter must be an integer greater than zero").build());
                return;
            }
            if (paginationLimit != null) {
                top = Math.min(top, paginationLimit.value());
            }
        }
        if (top <= 0) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The $top parameter must be an integer greater than zero").build());
            return;
        }
        requestContext.setProperty(TOP_PROP, (Object)top);
    }
}

