/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.annotation.dto.DuplicateAction;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.impl.SetValueCommand;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.push.DataUpdateException;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMetadataCommand
extends AbstractSensinactCommand<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(SetValueCommand.class);
    private final MetadataUpdateDto metadataUpdateDto;

    public SetMetadataCommand(MetadataUpdateDto metadataUpdateDto) {
        this.metadataUpdateDto = metadataUpdateDto;
    }

    protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
        SensinactResource resource = this.metadataUpdateDto.model != null ? twin.getResource(this.metadataUpdateDto.modelPackageUri, this.metadataUpdateDto.model, this.metadataUpdateDto.provider, this.metadataUpdateDto.service, this.metadataUpdateDto.resource) : twin.getResource(this.metadataUpdateDto.provider, this.metadataUpdateDto.service, this.metadataUpdateDto.resource);
        Stream<Promise> stream = this.metadataUpdateDto.removeMissingValues ? Stream.of(promiseFactory.failed((Throwable)new UnsupportedOperationException("Not yet implemented"))) : this.metadataUpdateDto.metadata.entrySet().stream().map(e -> this.updateMetdataValue(resource, (String)e.getKey(), e.getValue(), this.metadataUpdateDto, promiseFactory));
        List updates = stream.map(p -> p.recoverWith(pf -> promiseFactory.failed((Throwable)new DataUpdateException(this.metadataUpdateDto.modelPackageUri, this.metadataUpdateDto.model, this.metadataUpdateDto.provider, this.metadataUpdateDto.service, this.metadataUpdateDto.resource, this.metadataUpdateDto.originalDto, pf.getFailure())))).collect(Collectors.toList());
        return promiseFactory.all(updates).map(x -> null);
    }

    private Promise<Void> updateMetdataValue(SensinactResource resource, String key, Object value, MetadataUpdateDto metadataUpdateDto, PromiseFactory promiseFactory) {
        Function<TimedValue, Promise> cachedValueAction = null;
        if (value == null && metadataUpdateDto.actionOnNull == NullAction.UPDATE_IF_PRESENT) {
            cachedValueAction = v -> v.getTimestamp() == null ? promiseFactory.resolved(null) : resource.setMetadataValue(key, value, metadataUpdateDto.timestamp);
        } else if (metadataUpdateDto.actionOnDuplicate == DuplicateAction.UPDATE_IF_DIFFERENT) {
            cachedValueAction = v -> {
                if (v.getValue() == null) {
                    return value == null ? promiseFactory.resolved(null) : resource.setMetadataValue(key, value, metadataUpdateDto.timestamp);
                }
                return v.getValue().equals(value) ? promiseFactory.resolved(null) : resource.setMetadataValue(key, value, metadataUpdateDto.timestamp);
            };
        }
        if (cachedValueAction != null) {
            Promise p = resource.getMetadataValue(key).timeout(0L);
            try {
                Throwable t = p.getFailure();
                if (t != null) {
                    LOG.error("Unable to retrieve cached value for {}/{}/{}", new Object[]{metadataUpdateDto.provider, metadataUpdateDto.service, metadataUpdateDto.resource, t});
                    return promiseFactory.failed(t);
                }
                return cachedValueAction.apply((TimedValue)p.getValue());
            }
            catch (Exception e) {
                return promiseFactory.failed((Throwable)e);
            }
        }
        return resource.setMetadataValue(key, value, metadataUpdateDto.timestamp);
    }
}

