/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.LocationsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DatastreamsAccessImpl;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;

public class LocationsAccessImpl
extends AbstractAccess
implements LocationsAccess {
    public Location getLocation(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        Location l = DtoMapper.toLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        if (!id.equals(l.id)) {
            throw new NotFoundException();
        }
        return l;
    }

    public ResultList<HistoricalLocation> getLocationHistoricalLocations(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getLocationHistoricalLocation(id, id));
        return list;
    }

    public HistoricalLocation getLocationHistoricalLocation(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        HistoricalLocation hl = DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        if (!id2.equals(hl.id)) {
            throw new NotFoundException();
        }
        return hl;
    }

    public Thing getLocationHistoricalLocationsThing(String id, String id2) {
        if (!id2.equals(id)) {
            throw new NotFoundException();
        }
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        return DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
    }

    public ResultList<Location> getLocationHistoricalLocationLocations(String id, String id2) {
        ResultList list = new ResultList();
        list.value = List.of(this.getLocation(id));
        return list;
    }

    public ResultList<Thing> getLocationThings(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getLocationThing(id, id));
        return list;
    }

    public Thing getLocationThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        return DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
    }

    public ResultList<Datastream> getLocationThingDatastreams(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DatastreamsAccessImpl.getDataStreams(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetProvider(provider));
    }

    public ResultList<HistoricalLocation> getLocationThingHistoricalLocations(String id, String id2) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }

    public ResultList<Location> getLocationThingLocations(String id, String id2) {
        ResultList list = new ResultList();
        list.value = List.of(this.getLocation(id));
        return list;
    }
}

