/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import jakarta.ws.rs.NotFoundException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.ObservationsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;

public class ObservationsAccessImpl
extends AbstractAccess
implements ObservationsAccess {
    public Observation getObservation(String id) {
        ResourceSnapshot resourceSnapshot = this.validateAndGetResourceSnapshot(id);
        Instant timestamp = DtoMapper.getTimestampFromId(id);
        Observation result = null;
        if (resourceSnapshot.isSet()) {
            Instant milliTimestamp = resourceSnapshot.getValue().getTimestamp().truncatedTo(ChronoUnit.MILLIS);
            if (timestamp.isBefore(milliTimestamp)) {
                String history = (String)this.application.getProperties().get("sensinact.history.provider");
                if (history != null) {
                    String provider = resourceSnapshot.getService().getProvider().getName();
                    String service = resourceSnapshot.getService().getName();
                    String resource = resourceSnapshot.getName();
                    TimedValue t = (TimedValue)this.getSession().actOnResource(history, "history", "single", Map.of("provider", provider, "service", service, "resource", resource, "time", timestamp));
                    if (timestamp.equals(t.getTimestamp())) {
                        result = DtoMapper.toObservation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot, Optional.of(t));
                    }
                }
            } else if (timestamp.equals(milliTimestamp)) {
                result = DtoMapper.toObservation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot);
            }
        } else {
            result = DtoMapper.toObservation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot, Optional.empty());
        }
        if (result == null) {
            throw new NotFoundException();
        }
        return result;
    }

    public Datastream getObservationDatastream(String id) {
        ResourceSnapshot resourceSnapshot = this.validateAndGetResourceSnapshot(id);
        Datastream d = DtoMapper.toDatastream(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot);
        if (!id.startsWith(String.valueOf(d.id))) {
            throw new NotFoundException();
        }
        return d;
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getObservationDatastreamObservations(String id) {
        return RootResourceAccessImpl.getObservationList(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id), 0);
    }

    public ObservedProperty getObservationDatastreamObservedProperty(String id) {
        ResourceSnapshot resourceSnapshot = this.validateAndGetResourceSnapshot(id);
        return DtoMapper.toObservedProperty(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot);
    }

    public Sensor getObservationDatastreamSensor(String id) {
        ResourceSnapshot resourceSnapshot = this.validateAndGetResourceSnapshot(id);
        Sensor s = DtoMapper.toSensor(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resourceSnapshot);
        if (!id.startsWith(String.valueOf(s.id))) {
            throw new NotFoundException();
        }
        return s;
    }

    public Thing getObservationDatastreamThing(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        Thing t = DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        if (!provider.equals(t.id)) {
            throw new NotFoundException();
        }
        return t;
    }

    public FeatureOfInterest getObservationFeatureOfInterest(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        return DtoMapper.toFeatureOfInterest(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
    }

    public ResultList<Observation> getObservationFeatureOfInterestObservations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        ResultList list = new ResultList();
        list.value = providerSnapshot.getServices().stream().flatMap(s -> s.getResources().stream()).filter(ResourceSnapshot::isSet).map(r -> DtoMapper.toObservation(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), r)).collect(Collectors.toList());
        return list;
    }
}

