/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.ObservedPropertiesMapper;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.osgi.util.promise.Promise;

public class ObservedPropertyMapper
extends ObservedPropertiesMapper {
    private final String provider;
    private final String service;
    private final String resource;

    public ObservedPropertyMapper(String topicFilter, String id, ObjectMapper mapper, GatewayThread thread) {
        super(topicFilter, mapper, thread);
        String[] segments = id.split("~");
        if (segments.length != 3) {
            throw new IllegalArgumentException("The Sensor id " + id + " is not valid");
        }
        this.provider = segments[0];
        this.service = segments[1];
        this.resource = segments[2];
    }

    @Override
    public Promise<Stream<ObservedProperty>> toPayload(AbstractResourceNotification notification) {
        if (this.provider.equals(notification.provider) && this.service.equals(notification.service) && this.resource.equals(notification.resource)) {
            return super.toPayload(notification);
        }
        return this.emptyStream();
    }
}

