/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.emf.model.EMFModel;
import org.eclipse.sensinact.core.emf.model.EMFModelBuilder;
import org.eclipse.sensinact.core.emf.model.SensinactEMFModelManager;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.impl.ModelBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ModelImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;

public class SensinactModelManagerImpl
extends CommandScopedImpl
implements SensinactEMFModelManager {
    private final ModelNexus nexusImpl;

    public SensinactModelManagerImpl(ModelNexus nexusImpl) {
        super(new AtomicBoolean(true));
        this.nexusImpl = nexusImpl;
    }

    public EMFModelBuilder createModel(String model) {
        this.checkValid();
        return new ModelBuilderImpl(this.active, this.nexusImpl, null, model);
    }

    public EMFModelBuilder createModel(String packageUri, String model) {
        this.checkValid();
        return new ModelBuilderImpl(this.active, this.nexusImpl, packageUri, model);
    }

    public EMFModel getModel(String model) {
        return this.getModel(null, model);
    }

    public EMFModel getModel(String packageUri, String model) {
        this.checkValid();
        return this.nexusImpl.getModel(packageUri, model).map(eClass -> new ModelImpl(this.active, model, (EClass)eClass, this.nexusImpl)).orElse(null);
    }

    public void deleteModel(String model) {
        this.deleteModel(null, model);
    }

    public void deleteModel(String packageUri, String model) {
        this.checkValid();
        this.nexusImpl.deleteModel(packageUri, model);
    }

    public void registerModel(String packageUri, String model) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public void registerModel(InputStream model) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public Map<String, Model> getModels() {
        this.checkValid();
        return this.nexusImpl.getModelNames().stream().collect(Collectors.toMap(Function.identity(), this::getModel));
    }

    public EMFModel getModel(EClass model) {
        if (this.nexusImpl.registered(model)) {
            return new ModelImpl(this.active, EMFUtil.getModelName(model), model, this.nexusImpl);
        }
        return null;
    }

    public EMFModelBuilder createModel(EClass model) {
        return new ModelBuilderImpl(this.active, this.nexusImpl, model);
    }
}

