/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.whiteboard.impl;

import java.util.Objects;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;

class RegistryKey {
    private final String modelPackageUri;
    private final String model;
    private final String service;
    private final String resource;
    private final KeyLevel level;

    public RegistryKey(String modelPackageUri, String model, String service, String resource) {
        this.modelPackageUri = modelPackageUri == null || modelPackageUri.isBlank() || "<<NOT_SET>>".equals(modelPackageUri) ? EMFUtil.constructPackageUri(model) : modelPackageUri;
        this.model = model;
        this.service = service;
        this.resource = resource;
        this.level = resource != null ? KeyLevel.RESOURCE : (service != null ? KeyLevel.SERVICE : (model != null ? KeyLevel.MODEL : KeyLevel.MODEL_PACKAGE_URI));
    }

    public String getModelPackageUri() {
        return this.modelPackageUri;
    }

    public String getModel() {
        return this.model;
    }

    public String getService() {
        return this.service;
    }

    public String getResource() {
        return this.resource;
    }

    public int hashCode() {
        return Objects.hash(this.modelPackageUri, this.model, this.service, this.resource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistryKey other = (RegistryKey)obj;
        return Objects.equals(this.modelPackageUri, other.modelPackageUri) && Objects.equals(this.model, other.model) && Objects.equals(this.service, other.service) && Objects.equals(this.resource, other.resource);
    }

    public String toString() {
        return "RegistryKey [modelPackageUri=" + this.modelPackageUri + ", model=" + this.model + ", service=" + this.service + ", resource=" + this.resource + ", level=" + this.level + "]";
    }

    public RegistryKey levelUp() {
        switch (this.level) {
            case RESOURCE: {
                return new RegistryKey(this.modelPackageUri, this.model, this.service, null);
            }
            case SERVICE: {
                return new RegistryKey(this.modelPackageUri, this.model, null, null);
            }
            case MODEL: {
                return new RegistryKey(this.modelPackageUri, null, null, null);
            }
        }
        return null;
    }

    private static enum KeyLevel {
        MODEL_PACKAGE_URI,
        MODEL,
        SERVICE,
        RESOURCE;

    }
}

