/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.antlr.impl;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.LdapFilterParser;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.LdapFilterParserBaseVisitor;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.Constants;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.CriterionProviderModel;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.CriterionProviderName;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.CriterionProviderPackageUri;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.CriterionResourceOperator;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.CriterionResourcePresence;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.ILdapCriterion;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.IStringValue;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.LdapComparator;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.LdapOperator;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.PureString;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.SensiNactPath;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.ValueVisitor;
import org.eclipse.sensinact.northbound.filters.ldap.impl.LdapFilter;

public class FilterVisitor
extends LdapFilterParserBaseVisitor<ILdapCriterion> {
    private final ValueVisitor valueVisitor = new ValueVisitor();
    final Parser parser;

    public FilterVisitor(Parser parser) {
        this.parser = parser;
    }

    @Override
    public ILdapCriterion visitFilter(LdapFilterParser.FilterContext ctx) {
        return (ILdapCriterion)this.visitFilterContent((LdapFilterParser.FilterContentContext)((Object)ctx.getRuleContexts(LdapFilterParser.FilterContentContext.class).get(0)));
    }

    private ILdapCriterion subVisitOpFilter(LdapOperator operator, ParserRuleContext ctx) {
        ArrayList<ILdapCriterion> subCriteria = new ArrayList<ILdapCriterion>();
        for (LdapFilterParser.FilterContext filterContext : ctx.getRuleContexts(LdapFilterParser.FilterContext.class)) {
            ILdapCriterion subCriterion = this.visitFilter(filterContext);
            if (subCriterion == null) continue;
            subCriteria.add(subCriterion);
        }
        if (subCriteria.isEmpty()) {
            return null;
        }
        return new LdapFilter(operator, subCriteria);
    }

    @Override
    public ILdapCriterion visitAndFilter(LdapFilterParser.AndFilterContext ctx) {
        return this.subVisitOpFilter(LdapOperator.AND, ctx);
    }

    @Override
    public ILdapCriterion visitOrFilter(LdapFilterParser.OrFilterContext ctx) {
        return this.subVisitOpFilter(LdapOperator.OR, ctx);
    }

    @Override
    public ILdapCriterion visitNotFilter(LdapFilterParser.NotFilterContext ctx) {
        ILdapCriterion criterion = this.visitFilter(ctx.filter());
        criterion.negate();
        return criterion;
    }

    private LdapComparator extractComparator(LdapFilterParser.ComparatorContext comparator) {
        TerminalNode childNode = (TerminalNode)comparator.getChild(0);
        switch (childNode.getSymbol().getType()) {
            case 14: {
                return LdapComparator.EQUAL;
            }
            case 12: {
                return LdapComparator.GREATER_EQ;
            }
            case 13: {
                return LdapComparator.LESS_EQ;
            }
            case 11: {
                return LdapComparator.APPROX;
            }
        }
        throw new IllegalArgumentException("Unexpected comparator: " + comparator.getText());
    }

    private ILdapCriterion handleComparisonWithConstant(TerminalNode node, LdapComparator comparator, Object value) throws IllegalArgumentException {
        IStringValue strValue = value instanceof IStringValue ? (IStringValue)value : new PureString(String.valueOf(value));
        switch (node.getSymbol().getType()) {
            case 21: {
                if (value == null) {
                    throw new IllegalArgumentException("Package URIs can't be null");
                }
                if (value == Constants.ANY) {
                    return null;
                }
                switch (comparator) {
                    case APPROX: 
                    case EQUAL: {
                        return new CriterionProviderPackageUri(strValue, comparator);
                    }
                }
                throw new IllegalArgumentException("Model package URIs can only be tested with ~= or =, not " + comparator);
            }
            case 22: {
                if (value == null) {
                    throw new IllegalArgumentException("Models can't be null");
                }
                if (value == Constants.ANY) {
                    return null;
                }
                switch (comparator) {
                    case APPROX: 
                    case EQUAL: {
                        return new CriterionProviderModel(strValue, comparator);
                    }
                }
                throw new IllegalArgumentException("Models can only be tested with ~= or =, not " + comparator);
            }
            case 23: {
                if (value == null) {
                    throw new IllegalArgumentException("Provider name can't be null");
                }
                if (value == Constants.ANY) {
                    return null;
                }
                switch (comparator) {
                    case APPROX: 
                    case EQUAL: {
                        return new CriterionProviderName(strValue, comparator);
                    }
                }
                throw new IllegalArgumentException("Providers can only be tested with ~= or =, not " + comparator);
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type: " + node.getText());
    }

    private ILdapCriterion handlePathComparison(LdapFilterParser.AttrContext attr, LdapComparator comparator, Object value) throws IllegalArgumentException {
        SensiNactPath rcPath;
        List ruleContexts = attr.getRuleContexts(LdapFilterParser.Valid_attrContext.class);
        String[] parts = new String[ruleContexts.size()];
        int i = 0;
        for (LdapFilterParser.Valid_attrContext partContext : ruleContexts) {
            if (partContext.STAR() != null) {
                parts[i++] = null;
                continue;
            }
            parts[i++] = partContext.getText();
        }
        switch (parts.length) {
            case 1: {
                rcPath = new SensiNactPath(null, parts[0]);
                break;
            }
            case 2: {
                rcPath = new SensiNactPath(parts[0], parts[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported LDAP target: " + attr.getText());
            }
        }
        if (value == Constants.ANY) {
            return new CriterionResourcePresence(rcPath);
        }
        return new CriterionResourceOperator(rcPath, value, comparator);
    }

    @Override
    public ILdapCriterion visitComparison(LdapFilterParser.ComparisonContext ctx) {
        LdapComparator comparator = this.extractComparator(ctx.comparator());
        Object value = this.valueVisitor.visit((ParseTree)ctx);
        LdapFilterParser.AttrContext attr = ctx.attr();
        ParseTree attrFirstChild = attr.getChild(0);
        if (attrFirstChild instanceof TerminalNode) {
            return this.handleComparisonWithConstant((TerminalNode)attrFirstChild, comparator, value);
        }
        if (attrFirstChild instanceof LdapFilterParser.Valid_attrContext) {
            return this.handlePathComparison(attr, comparator, value);
        }
        throw new IllegalArgumentException("Unsupported parser context: " + attr.getText());
    }
}

