/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.command.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.core.command.CommandScoped;

public abstract class CommandScopedImpl
implements CommandScoped {
    protected final AtomicBoolean active;
    private final Thread creatingThread = Thread.currentThread();

    public CommandScopedImpl(AtomicBoolean active) {
        this.active = active;
    }

    public void invalidate() {
        this.active.set(false);
    }

    public boolean isValid() {
        return this.active.get();
    }

    protected void checkValid() {
        if (!this.active.get()) {
            throw new IllegalStateException("This scoped object has been closed");
        }
        if (!this.creatingThread.equals(Thread.currentThread())) {
            throw new IllegalStateException("This scoped object is being accessed from outside the creating thread");
        }
    }
}

