/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl.snapshot;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.sensinact.core.impl.snapshot.AbstractSnapshot;
import org.eclipse.sensinact.core.impl.snapshot.ProviderSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ResourceSnapshotImpl;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.model.core.provider.Service;

public class ServiceSnapshotImpl
extends AbstractSnapshot
implements ServiceSnapshot {
    private final Map<String, ResourceSnapshotImpl> resources = new LinkedHashMap<String, ResourceSnapshotImpl>();
    private final ProviderSnapshotImpl provider;
    private final EClass modelEClass;
    private final Service modelService;

    public ServiceSnapshotImpl(ProviderSnapshotImpl parent, String serviceName, Map.Entry<EClass, Service> modelService, Instant timestamp) {
        super(serviceName, timestamp);
        this.provider = parent;
        this.modelEClass = modelService.getKey();
        this.modelService = modelService.getValue();
    }

    public String toString() {
        ProviderSnapshotImpl provider = this.getProvider();
        return String.format("ServiceSnapshot(%s/%s/%s, %s)", provider.getModelName(), provider.getName(), this.getName(), this.getSnapshotTime());
    }

    public ProviderSnapshotImpl getProvider() {
        return this.provider;
    }

    public EClass getModelEClass() {
        return this.modelEClass;
    }

    public Service getModelService() {
        return this.modelService;
    }

    public void add(ResourceSnapshotImpl rc) {
        this.resources.put(rc.getName(), rc);
    }

    public List<ResourceSnapshotImpl> getResources() {
        return List.copyOf(this.resources.values());
    }

    public ResourceSnapshotImpl getResource(String name) {
        return this.resources.get(name);
    }
}

