/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.notification.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.notification.ResourceActionNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.core.notification.impl.AbstractNotificationAccumulatorImpl;
import org.eclipse.sensinact.core.notification.impl.NotificationKey;
import org.osgi.service.typedevent.TypedEventBus;

public class NotificationAccumulatorImpl
extends AbstractNotificationAccumulatorImpl
implements NotificationAccumulator {
    private final TypedEventBus eventBus;
    private final SortedMap<NotificationKey, List<AbstractResourceNotification>> notifications = new TreeMap<NotificationKey, List<AbstractResourceNotification>>();

    public NotificationAccumulatorImpl(TypedEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void addProvider(String modelPackageUri, String model, String name) {
        this.doLifecycleMerge(LifecycleNotification.Status.PROVIDER_CREATED, modelPackageUri, model, name, null, null, null, null, false);
    }

    public void removeProvider(String modelPackageUri, String model, String name) {
        this.doLifecycleMerge(LifecycleNotification.Status.PROVIDER_DELETED, modelPackageUri, model, name, null, null, null, null, true);
    }

    public void addService(String modelPackageUri, String model, String provider, String name) {
        this.doLifecycleMerge(LifecycleNotification.Status.SERVICE_CREATED, modelPackageUri, model, provider, name, null, null, null, false);
    }

    public void removeService(String modelPackageUri, String model, String provider, String name) {
        this.doLifecycleMerge(LifecycleNotification.Status.SERVICE_DELETED, modelPackageUri, model, provider, name, null, null, null, true);
    }

    public void addResource(String modelPackageUri, String model, String provider, String service, String name) {
        this.doLifecycleMerge(LifecycleNotification.Status.RESOURCE_CREATED, modelPackageUri, model, provider, service, name, null, null, false);
    }

    public void removeResource(String modelPackageUri, String model, String provider, String service, String name) {
        this.doLifecycleMerge(LifecycleNotification.Status.RESOURCE_DELETED, modelPackageUri, model, provider, service, name, null, null, true);
    }

    private void doLifecycleMerge(LifecycleNotification.Status status, String modelPackageUri, String model, String provider, String service, String resource, Object initialValue, Map<String, Object> initialMetadata, boolean isDelete) {
        this.check();
        this.notifications.compute(new NotificationKey(provider, service, resource, LifecycleNotification.class), (a, b) -> {
            LifecycleNotification ln = this.createLifecycleNotification(status, modelPackageUri, model, provider, service, resource, initialValue, initialMetadata);
            if (b != null) {
                LifecycleNotification.Status s = ((LifecycleNotification)b.get((int)(b.size() - 1))).status;
                if (s == status) {
                    return b.size() == 2 ? List.of((AbstractResourceNotification)b.get(0), ln) : List.of(ln);
                }
                if (isDelete) {
                    return b.size() == 1 ? null : List.of(ln);
                }
                return List.of((AbstractResourceNotification)b.get(0), ln);
            }
            return List.of(ln);
        });
    }

    public void metadataValueUpdate(String modelPackageUri, String model, String provider, String service, String resource, Map<String, Object> oldValues, Map<String, Object> newValues, Instant timestamp) {
        this.check();
        Map<Object, Object> nonNullOldValues = oldValues == null ? Collections.emptyMap() : oldValues;
        Map<Object, Object> nonNullNewValues = newValues == null ? Collections.emptyMap() : newValues;
        Objects.requireNonNull(timestamp);
        this.notifications.compute(new NotificationKey(provider, service, resource, ResourceMetaDataNotification.class), (a, b) -> {
            Instant timestampToUse;
            Map newValuesToUse;
            Map oldValuesToUse;
            if (b != null) {
                ResourceMetaDataNotification previous = (ResourceMetaDataNotification)b.get(0);
                oldValuesToUse = previous.oldValues;
                if (previous.timestamp.isAfter(timestamp)) {
                    throw new IllegalArgumentException("Received metadata updates out of temporal order");
                }
                newValuesToUse = nonNullNewValues;
                timestampToUse = timestamp;
            } else {
                oldValuesToUse = nonNullOldValues;
                newValuesToUse = nonNullNewValues;
                timestampToUse = timestamp;
            }
            return List.of(this.createResourceMetaDataNotification(modelPackageUri, model, provider, service, resource, oldValuesToUse, newValuesToUse, timestampToUse));
        });
    }

    public void resourceValueUpdate(String modelPackageUri, String model, String provider, String service, String resource, Class<?> type, Object oldValue, Object newValue, Instant timestamp) {
        this.check();
        Objects.requireNonNull(timestamp);
        this.notifications.compute(new NotificationKey(provider, service, resource, ResourceDataNotification.class), (a, b) -> {
            Object oldValueToUse;
            if (b != null) {
                ResourceDataNotification previous = (ResourceDataNotification)b.get(0);
                if (previous.timestamp.isAfter(timestamp)) {
                    throw new IllegalArgumentException("Received resource value updates out of temporal order");
                }
                oldValueToUse = previous.oldValue;
            } else {
                oldValueToUse = oldValue;
            }
            return List.of(this.createResourceDataNotification(modelPackageUri, model, provider, service, resource, type, oldValueToUse, newValue, timestamp));
        });
    }

    public void resourceAction(String modelPackageUri, String model, String provider, String service, String resource, Instant timestamp) {
        this.check();
        Objects.requireNonNull(timestamp);
        this.notifications.compute(new NotificationKey(provider, service, resource, ResourceActionNotification.class), (a, b) -> {
            ResourceActionNotification ran = this.createResourceActionNotification(modelPackageUri, model, provider, service, resource, timestamp);
            if (b != null) {
                return Stream.concat(b.stream(), Stream.of(ran)).map(ResourceActionNotification.class::cast).sorted((i, j) -> i.timestamp.compareTo(j.timestamp)).collect(Collectors.toList());
            }
            return List.of(ran);
        });
    }

    @Override
    protected void doComplete() {
        this.notifications.values().stream().flatMap(Collection::stream).forEach(n -> this.eventBus.deliver(n.getTopic(), n));
    }
}

