/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.dto.query.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.northbound.query.dto.query.AccessMethodCallParameterDTO;

public class ActParametersDeserializer
extends StdNodeBasedDeserializer<Map<String, Object>> {
    private static final long serialVersionUID = 1L;

    public ActParametersDeserializer() {
        super((JavaType)TypeFactory.defaultInstance().constructMapLikeType(Map.class, String.class, Object.class));
    }

    public Map<String, Object> convert(JsonNode node, DeserializationContext ctxt) throws IOException, JacksonException {
        if (node.isNull()) {
            return Map.of();
        }
        ObjectMapper mapper = new ObjectMapper();
        if (node.isObject()) {
            Map rawParams = (Map)mapper.convertValue((Object)node, Map.class);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (Map.Entry entry : rawParams.entrySet()) {
                parameters.put(String.valueOf(entry.getKey()), entry.getValue());
            }
            return parameters;
        }
        if (node.isArray()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (JsonNode item : node) {
                AccessMethodCallParameterDTO rawParam = (AccessMethodCallParameterDTO)mapper.convertValue((Object)item, AccessMethodCallParameterDTO.class);
                parameters.put(rawParam.name, rawParam.value);
            }
            return parameters;
        }
        throw new IOException("Invalid arguments list/map");
    }
}

