/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.integration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.Application;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.northbound.query.api.AbstractResultDTO;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.result.CompleteProviderDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeProviderDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeResourceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeServiceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultDescribeProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListProvidersDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListResourcesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListServicesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ShortResourceDescriptionDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.rest.integration.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import org.osgi.service.cm.Configuration;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.service.ServiceAware;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class DescriptionsTest {
    private static final String PROVIDER = "RestDescriptionProvider";
    private static final String PROVIDER_2 = "RestDescriptionProvider_2";
    private static final String PROVIDER_3 = "RestDescriptionProvider_3";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    @InjectService
    DataUpdate push;
    final TestUtils utils = new TestUtils();

    @BeforeEach
    public void await(@InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.northbound.rest", location="?", properties={@Property(key="allow.anonymous", value={"true"}), @Property(key="foo", value={"bar"})})) Configuration cm, @InjectService(filter="(foo=bar)", cardinality=0) ServiceAware<Application> a) throws InterruptedException {
        a.waitForService(5000L);
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.utils.queryStatus("/").statusCode() == 200) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(200L);
        }
        throw new AssertionFailedError("REST API did not appear");
    }

    @AfterEach
    public void clear(@InjectConfiguration(value="sensinact.northbound.rest") Configuration cm) throws Exception {
        cm.delete();
        Thread.sleep(500L);
    }

    @Test
    void completeList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        ResultDescribeProvidersDTO result = this.utils.queryJson("/", ResultDescribeProvidersDTO.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.COMPLETE_LIST, new String[0]);
        CompleteProviderDescriptionDTO providerDto = result.providers.stream().filter(p -> PROVIDER.equals(p.name)).findFirst().get();
        boolean gotAdmin = false;
        boolean gotService = false;
        block8: for (ResponseDescribeServiceDTO svc : providerDto.services) {
            List resources = svc.resources.stream().map(r -> r.name).collect(Collectors.toList());
            switch (svc.name) {
                case "admin": {
                    gotAdmin = true;
                    Assertions.assertTrue((boolean)resources.contains("location"), (String)"Location admin resource is missing");
                    Assertions.assertTrue((boolean)resources.contains("friendlyName"), (String)"FriendlyName admin resource is missing");
                    continue block8;
                }
                case "service": {
                    gotService = true;
                    Assertions.assertEquals((int)1, (int)svc.resources.size(), (String)("Too many resources for the test service: " + resources));
                    Assertions.assertEquals((Object)RESOURCE, (Object)((ShortResourceDescriptionDTO)svc.resources.get((int)0)).name, (String)"Wrong test service resource name");
                    continue block8;
                }
            }
            Assertions.fail((String)("Unknown service found: " + svc.name));
        }
        Assertions.assertTrue((boolean)gotAdmin, (String)"Admin service not found");
        Assertions.assertTrue((boolean)gotService, (String)"Test service not found");
    }

    @Test
    void completeListWithQuery() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        dto = this.utils.makeDto(PROVIDER, "admin", "friendlyName", "Bob", String.class);
        this.push.pushUpdate((Object)dto).getValue();
        Map<String, double[]> location = Map.of("type", "Point", "coordinates", new double[]{12.3, 45.6});
        dto = this.utils.makeDto(PROVIDER, "admin", "location", this.utils.convert(location, GeoJsonObject.class), GeoJsonObject.class);
        this.push.pushUpdate((Object)dto).getValue();
        JsonNode providerDto = this.checkAndFindProvider(this.utils.queryJson("/", JsonNode.class));
        Assertions.assertFalse((boolean)providerDto.has("icon"));
        Assertions.assertFalse((boolean)providerDto.has("friendlyName"));
        Assertions.assertTrue((boolean)providerDto.has("location"));
        Assertions.assertEquals((Object)this.normalizedJson(location), (Object)this.normalizedJson(providerDto.get("location")));
        providerDto = this.checkAndFindProvider(this.utils.queryJson("/?attrs=icon&attrs=friendlyName", JsonNode.class));
        Assertions.assertTrue((boolean)providerDto.has("friendlyName"));
        Assertions.assertEquals((Object)"Bob", (Object)providerDto.get("friendlyName").asText());
        Assertions.assertFalse((boolean)providerDto.has("location"));
        providerDto = this.checkAndFindProvider(this.utils.queryJson("/?attrs=icon&attrs=friendlyName&attrs=location", JsonNode.class));
        Assertions.assertTrue((boolean)providerDto.has("friendlyName"));
        Assertions.assertEquals((Object)"Bob", (Object)providerDto.get("friendlyName").asText());
        Assertions.assertTrue((boolean)providerDto.has("location"));
        Assertions.assertEquals((Object)this.normalizedJson(location), (Object)this.normalizedJson(providerDto.get("location")));
    }

    private JsonNode checkAndFindProvider(JsonNode result) {
        JsonNode providers = result.get("providers");
        Assertions.assertNotNull((Object)providers);
        Assertions.assertTrue((boolean)providers.isArray());
        JsonNode providerDto = StreamSupport.stream(providers.spliterator(), false).filter(p -> PROVIDER.equals(p.get("name").asText())).findFirst().get();
        return providerDto;
    }

    private String normalizedJson(Object o) throws Exception {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = JsonFactory.builder().build().createGenerator((Writer)sw);
        JsonNode node = o instanceof JsonNode ? (JsonNode)o : this.utils.convert(o, JsonNode.class);
        if (node.isArray()) {
            gen.writeStartArray();
            for (JsonNode n : node) {
                gen.writeRawValue(this.normalizedJson(n));
            }
            gen.writeEndArray();
        } else if (node.isObject()) {
            TreeMap<String, JsonNode> map = new TreeMap<String, JsonNode>();
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry e = (Map.Entry)fields.next();
                map.put((String)e.getKey(), (JsonNode)e.getValue());
            }
            gen.writeStartObject();
            for (Map.Entry e : map.entrySet()) {
                gen.writeFieldName((String)e.getKey());
                gen.writeRawValue(this.normalizedJson(e.getValue()));
            }
            gen.writeEndObject();
        } else {
            return node.toString();
        }
        return sw.toString();
    }

    @Test
    void providersList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        ResultListProvidersDTO result = this.utils.queryJson("/providers", ResultListProvidersDTO.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.PROVIDERS_LIST, new String[0]);
        Assertions.assertFalse((boolean)result.providers.contains(PROVIDER_2), (String)"Unexpected provider is present");
        Assertions.assertTrue((boolean)result.providers.contains("sensiNact"), (String)"sensiNact provider is missing");
        Assertions.assertTrue((boolean)result.providers.contains(PROVIDER), (String)"Expected provider is missing");
        dto.model = dto.provider = PROVIDER_2;
        this.push.pushUpdate((Object)dto).getValue();
        result = this.utils.queryJson("/providers", ResultListProvidersDTO.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.PROVIDERS_LIST, new String[0]);
        Assertions.assertTrue((boolean)result.providers.contains("sensiNact"), (String)"sensiNact provider is missing");
        Assertions.assertTrue((boolean)result.providers.contains(PROVIDER), (String)"Expected provider is missing");
        Assertions.assertTrue((boolean)result.providers.contains(PROVIDER_2), (String)"Expected provider 2 is missing");
    }

    @Test
    void providerDescription() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson("/providers/RestDescriptionProvider", TypedResponse.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.DESCRIBE_PROVIDER, PROVIDER);
        ResponseDescribeProviderDTO descr = this.utils.convert(result, ResponseDescribeProviderDTO.class);
        Assertions.assertEquals((Object)PROVIDER, (Object)descr.name);
        Assertions.assertEquals(Set.of("admin", SERVICE), Set.copyOf(descr.services));
    }

    @Test
    void servicesList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        ResultListServicesDTO result = this.utils.queryJson("/providers/RestDescriptionProvider/services", ResultListServicesDTO.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.SERVICES_LIST, PROVIDER);
        Assertions.assertEquals(Set.of("admin", SERVICE), Set.copyOf(result.services));
    }

    @Test
    void serviceDescription() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson("/providers/RestDescriptionProvider/services/service", TypedResponse.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.DESCRIBE_SERVICE, PROVIDER, SERVICE);
        ResponseDescribeServiceDTO descr = this.utils.convert(result, ResponseDescribeServiceDTO.class);
        Assertions.assertEquals((Object)SERVICE, (Object)descr.name);
        Assertions.assertEquals(List.of(RESOURCE), descr.resources.stream().map(r -> r.name).collect(Collectors.toList()));
    }

    @Test
    void resourcesList() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        ResultListResourcesDTO result = this.utils.queryJson("/providers/RestDescriptionProvider/services/service/resources", ResultListResourcesDTO.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.RESOURCES_LIST, PROVIDER, SERVICE);
        Assertions.assertEquals(List.of(RESOURCE), (Object)result.resources);
    }

    @Test
    void resourceDescription() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson("/providers/RestDescriptionProvider/services/service/resources/resource", TypedResponse.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.DESCRIBE_RESOURCE, PROVIDER, SERVICE, RESOURCE);
        Assertions.assertEquals((Object)RESOURCE, (Object)this.utils.convert(result, ResponseDescribeResourceDTO.class).name);
    }

    @Test
    void filterTest() throws Exception {
        GenericDto dto = this.utils.makeDto(PROVIDER, SERVICE, RESOURCE, 12345678, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        GenericDto dto2 = this.utils.makeDto(PROVIDER_3, SERVICE, RESOURCE, 12345679, Integer.class);
        this.push.pushUpdate((Object)dto2).getValue();
        ResultDescribeProvidersDTO result = this.utils.queryJson("/?filter=(service.resource=" + dto.value + ")", ResultDescribeProvidersDTO.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.COMPLETE_LIST, new String[0]);
        Assertions.assertEquals((int)1, (int)result.providers.size());
        Assertions.assertEquals((Object)PROVIDER, (Object)((CompleteProviderDescriptionDTO)result.providers.get((int)0)).name);
        result = this.utils.queryJson("/?filter=(service.resource=" + dto2.value + ")", ResultDescribeProvidersDTO.class);
        this.utils.assertResultSuccess((AbstractResultDTO)result, EResultType.COMPLETE_LIST, new String[0]);
        Assertions.assertEquals((int)1, (int)result.providers.size());
        Assertions.assertEquals((Object)PROVIDER_3, (Object)((CompleteProviderDescriptionDTO)result.providers.get((int)0)).name);
    }
}

