/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.rest.integration;

import jakarta.ws.rs.core.Application;
import java.time.Instant;
import java.util.List;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.northbound.query.dto.result.ErrorResultDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeProviderDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListResourcesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResultListServicesDTO;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;
import org.eclipse.sensinact.northbound.rest.integration.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import org.osgi.service.cm.Configuration;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.InjectConfiguration;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.service.ServiceAware;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"ALLOW_ALL"})})
public class MissingEntityTest {
    private static final String PROVIDER = "RestMissingSvcProvider";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    @InjectService
    DataUpdate push;
    final TestUtils utils = new TestUtils();

    @BeforeEach
    public void await(@InjectConfiguration(withConfig=@WithConfiguration(pid="sensinact.northbound.rest", location="?", properties={@Property(key="allow.anonymous", value={"true"}), @Property(key="bar", value={"foobar"})})) Configuration cm, @InjectService(filter="(bar=foobar)", cardinality=0) ServiceAware<Application> a) throws InterruptedException {
        a.waitForService(5000L);
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.utils.queryStatus("/").statusCode() == 200) {
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(200L);
        }
        throw new AssertionFailedError("REST API did not appear");
    }

    @Test
    void missingProvider() throws Exception {
        String missingProvider = "RestMissingSvcProvider__missing__";
        ErrorResultDTO typedResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", "RestMissingSvcProvider__missing__", "services", SERVICE), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)typedResult.statusCode);
        Assertions.assertNotNull((Object)typedResult.error);
        Assertions.assertFalse((boolean)typedResult.error.isEmpty());
        ErrorResultDTO rcListResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", "RestMissingSvcProvider__missing__", "services", SERVICE, "resources"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)rcListResult.statusCode);
        Assertions.assertNotNull((Object)rcListResult.error);
        Assertions.assertFalse((boolean)rcListResult.error.isEmpty());
        typedResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", "RestMissingSvcProvider__missing__", "services", SERVICE, "resources", RESOURCE), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)typedResult.statusCode);
        Assertions.assertNotNull((Object)typedResult.error);
        Assertions.assertFalse((boolean)typedResult.error.isEmpty());
        typedResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", "RestMissingSvcProvider__missing__", "services", SERVICE, "resources", RESOURCE, "GET"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)typedResult.statusCode);
        Assertions.assertNotNull((Object)typedResult.error);
        Assertions.assertFalse((boolean)typedResult.error.isEmpty());
        typedResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", "RestMissingSvcProvider__missing__"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)typedResult.statusCode);
        Assertions.assertNotNull((Object)typedResult.error);
        Assertions.assertFalse((boolean)typedResult.error.isEmpty());
        ErrorResultDTO svcListResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", "RestMissingSvcProvider__missing__", "services"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)svcListResult.statusCode);
        Assertions.assertNotNull((Object)svcListResult.error);
        Assertions.assertFalse((boolean)svcListResult.error.isEmpty());
    }

    @Test
    void missingService() throws Exception {
        String provider_service = "RestMissingSvcProviderService";
        GenericDto dto = this.utils.makeDto(provider_service, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        TypedResponse result = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_service, "services", SERVICE, "resources", RESOURCE, "GET"), TypedResponse.class);
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertEquals((Object)VALUE, (Object)response.value);
        String missingService = "service__missing__";
        ErrorResultDTO errorResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_service, "services", "service__missing__"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)errorResult.statusCode);
        Assertions.assertNotNull((Object)errorResult.error);
        Assertions.assertFalse((boolean)errorResult.error.isEmpty());
        errorResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_service, "services", "service__missing__", "resources"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)errorResult.statusCode);
        Assertions.assertNotNull((Object)errorResult.error);
        Assertions.assertFalse((boolean)errorResult.error.isEmpty());
        errorResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_service, "services", "service__missing__", "resources", RESOURCE), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)errorResult.statusCode);
        Assertions.assertNotNull((Object)errorResult.error);
        Assertions.assertFalse((boolean)errorResult.error.isEmpty());
        errorResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_service, "services", "service__missing__", "resources", RESOURCE, "GET"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)errorResult.statusCode);
        Assertions.assertNotNull((Object)errorResult.error);
        Assertions.assertFalse((boolean)errorResult.error.isEmpty());
        TypedResponse typedResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_service), TypedResponse.class);
        Assertions.assertEquals((int)200, (int)typedResult.statusCode);
        ResponseDescribeProviderDTO provider = this.utils.convert(typedResult, ResponseDescribeProviderDTO.class);
        Assertions.assertEquals((Object)provider_service, (Object)provider.name);
        Assertions.assertFalse((boolean)provider.services.contains("service__missing__"), (String)"Missing service is registered");
        ResultListServicesDTO svcListResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_service, "services"), ResultListServicesDTO.class);
        Assertions.assertEquals((int)200, (int)svcListResult.statusCode);
        Assertions.assertFalse((boolean)svcListResult.services.contains("service__missing__"), (String)"Missing service is registered");
    }

    @Test
    void missingResource() throws Exception {
        String provider_resource = "RestMissingSvcProvider_resource";
        GenericDto dto = this.utils.makeDto(provider_resource, SERVICE, RESOURCE, VALUE, Integer.class);
        this.push.pushUpdate((Object)dto).getValue();
        String missingResource = "resource__missing__";
        ResultListResourcesDTO rcListResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_resource, "services", SERVICE, "resources"), ResultListResourcesDTO.class);
        Assertions.assertEquals((int)200, (int)rcListResult.statusCode);
        Assertions.assertFalse((boolean)rcListResult.resources.contains("resource__missing__"), (String)"Missing resource is registered");
        ErrorResultDTO result = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider_resource, "services", SERVICE, "resources", "resource__missing__", "GET"), ErrorResultDTO.class);
        Assertions.assertEquals((int)404, (int)result.statusCode);
        Assertions.assertNotNull((Object)result.error, (String)"No warning message set");
        Assertions.assertFalse((boolean)result.error.isEmpty(), (String)"No warning message set");
    }

    @Test
    void unsetResource() throws Exception {
        String provider2 = "RestMissingSvcProvider_2";
        BulkGenericDto dto = new BulkGenericDto();
        dto.dtos = List.of(this.utils.makeDto("model", PROVIDER, SERVICE, RESOURCE, VALUE, Integer.class), this.utils.makeDto("model", provider2, "admin", "friendlyName", "test", String.class));
        this.push.pushUpdate((Object)dto).getValue();
        ResultListResourcesDTO rcListResult = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider2, "services", SERVICE, "resources"), ResultListResourcesDTO.class);
        Assertions.assertEquals((int)200, (int)rcListResult.statusCode);
        Assertions.assertTrue((boolean)rcListResult.resources.contains(RESOURCE), (String)"Resource is not registered");
        Instant queryTime = Instant.now();
        TypedResponse result = this.utils.queryJson(String.join((CharSequence)"/", "providers", provider2, "services", SERVICE, "resources", RESOURCE, "GET"), TypedResponse.class);
        Assertions.assertEquals((int)204, (int)result.statusCode);
        Assertions.assertNotNull((Object)result.error, (String)"No warning message set");
        Assertions.assertFalse((boolean)result.error.isEmpty(), (String)"No warning message set");
        ResponseGetDTO response = this.utils.convert(result, ResponseGetDTO.class);
        Assertions.assertNotNull((Object)response, (String)"No empty value response");
        Assertions.assertFalse((boolean)queryTime.isAfter(Instant.ofEpochMilli(response.timestamp)), (String)"Missing resource has a timestamp");
        Assertions.assertNull((Object)response.value, (String)"Got a value for a missing resource");
    }
}

