/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.nortbound.session.integration;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.nortbound.session.impl.TestUserInfo;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@WithConfiguration(pid="sensinact.session.manager", properties={@Property(key="auth.policy", value={"AUTHENTICATED_ONLY"})})
public class SessionSubscribeTest {
    private static final UserInfo ANON = new TestUserInfo("<ANON>", false);
    private static final UserInfo BOB = new TestUserInfo("bob", true);
    private static final String MODEL = "model";
    private static final String PROVIDER = "provider";
    private static final String PROVIDER_TOPIC = "model/provider/*";
    private static final String SERVICE = "service";
    private static final String RESOURCE = "resource";
    private static final Integer VALUE = 42;
    private static final Integer VALUE_2 = 84;
    @InjectService
    SensiNactSessionManager sessionManager;
    @InjectService
    DataUpdate push;

    @AfterEach
    void stop() {
        SensiNactSession session = this.sessionManager.getDefaultSession(ANON);
        session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)session).removeListener(arg_0));
        session = this.sessionManager.getDefaultSession(BOB);
        session.activeListeners().keySet().forEach(arg_0 -> ((SensiNactSession)session).removeListener(arg_0));
    }

    @AfterEach
    void deleteProvider(@InjectService GatewayThread gt) throws Exception {
        gt.execute((AbstractSensinactCommand)new AbstractTwinCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, PromiseFactory pf) {
                SensinactProvider sp = twin.getProvider(SessionSubscribeTest.PROVIDER);
                if (sp != null) {
                    sp.delete();
                }
                return pf.resolved(null);
            }
        }).getValue();
    }

    @Test
    void basicSubscribe() throws Exception {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(32);
        SensiNactSession session = this.sessionManager.getDefaultSession(BOB);
        session.addListener(List.of(PROVIDER_TOPIC), (t, e) -> queue.offer(e), null, null, null);
        Assertions.assertNull(queue.poll(500L, TimeUnit.MILLISECONDS));
        GenericDto dto = new GenericDto();
        dto.model = MODEL;
        dto.provider = PROVIDER;
        dto.service = SERVICE;
        dto.resource = RESOURCE;
        dto.value = VALUE;
        dto.type = Integer.class;
        this.push.pushUpdate((Object)dto);
        ResourceDataNotification notification = (ResourceDataNotification)queue.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)PROVIDER, (Object)notification.provider);
        Assertions.assertEquals((Object)ProviderPackage.Literals.PROVIDER__ADMIN.getName(), (Object)notification.service);
        Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__FRIENDLY_NAME.getName(), (Object)notification.resource);
        Assertions.assertEquals(null, (Object)notification.oldValue);
        Assertions.assertEquals((Object)PROVIDER, (Object)notification.newValue);
        notification = (ResourceDataNotification)queue.poll(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)PROVIDER, (Object)notification.provider);
        Assertions.assertEquals((Object)ProviderPackage.Literals.PROVIDER__ADMIN.getName(), (Object)notification.service);
        Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__MODEL.getName(), (Object)notification.resource);
        Assertions.assertEquals(null, (Object)notification.oldValue);
        notification = (ResourceDataNotification)queue.poll(1L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)PROVIDER, (Object)notification.provider);
        Assertions.assertEquals((Object)ProviderPackage.Literals.PROVIDER__ADMIN.getName(), (Object)notification.service);
        Assertions.assertEquals((Object)ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI.getName(), (Object)notification.resource);
        Assertions.assertEquals(null, (Object)notification.oldValue);
        notification = (ResourceDataNotification)queue.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)PROVIDER, (Object)notification.provider);
        Assertions.assertEquals((Object)SERVICE, (Object)notification.service);
        Assertions.assertEquals((Object)RESOURCE, (Object)notification.resource);
        Assertions.assertEquals(null, (Object)notification.oldValue);
        Assertions.assertEquals((Object)VALUE, (Object)notification.newValue);
        Assertions.assertNull(queue.poll(500L, TimeUnit.MILLISECONDS));
        dto.value = VALUE_2;
        this.push.pushUpdate((Object)dto);
        notification = (ResourceDataNotification)queue.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)notification);
        Assertions.assertEquals((Object)PROVIDER, (Object)notification.provider);
        Assertions.assertEquals((Object)SERVICE, (Object)notification.service);
        Assertions.assertEquals((Object)RESOURCE, (Object)notification.resource);
        Assertions.assertEquals((Object)VALUE, (Object)notification.oldValue);
        Assertions.assertEquals((Object)VALUE_2, (Object)notification.newValue);
        Assertions.assertNull(queue.poll(500L, TimeUnit.MILLISECONDS));
    }

    @Test
    void basicSubscribeWithoutPermission() throws Exception {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(32);
        SensiNactSession session = this.sessionManager.getDefaultSession(ANON);
        session.addListener(List.of(PROVIDER_TOPIC), (t, e) -> queue.offer(e), null, null, null);
        Assertions.assertNull(queue.poll(500L, TimeUnit.MILLISECONDS));
        GenericDto dto = new GenericDto();
        dto.model = MODEL;
        dto.provider = PROVIDER;
        dto.service = SERVICE;
        dto.resource = RESOURCE;
        dto.value = VALUE;
        dto.type = Integer.class;
        this.push.pushUpdate((Object)dto);
        Assertions.assertNull(queue.poll(1L, TimeUnit.SECONDS));
    }
}

