/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.device.factory.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.southbound.device.factory.IDeviceMappingParser;
import org.eclipse.sensinact.gateway.southbound.device.factory.dto.DeviceMappingConfigurationDTO;
import org.eclipse.sensinact.gateway.southbound.device.factory.impl.DeviceMappingParserReference;
import org.eclipse.sensinact.gateway.southbound.device.factory.impl.FactoryParserHandler;
import org.eclipse.sensinact.gateway.southbound.device.factory.parser.json.JsonParser;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.util.promise.Promises;

public class JSONParserTest {
    private FactoryParserHandler deviceMapper;
    private ComponentServiceObjects<IDeviceMappingParser> cso;
    private List<BulkGenericDto> bulks = new ArrayList<BulkGenericDto>();

    @BeforeEach
    void start() throws InterruptedException {
        this.deviceMapper = new FactoryParserHandler();
        this.deviceMapper.dataUpdate = (DataUpdate)Mockito.mock(DataUpdate.class);
        Mockito.when((Object)this.deviceMapper.dataUpdate.pushUpdate(Mockito.any())).thenAnswer(i -> {
            BulkGenericDto dto = (BulkGenericDto)i.getArgument(0, BulkGenericDto.class);
            this.bulks.add(dto);
            return Promises.resolved((Object)dto);
        });
        final JsonParser parser = new JsonParser();
        final DeviceMappingParserReference svcRef = new DeviceMappingParserReference();
        this.cso = new ComponentServiceObjects<IDeviceMappingParser>(){

            public IDeviceMappingParser getService() {
                return parser;
            }

            public ServiceReference<IDeviceMappingParser> getServiceReference() {
                return svcRef;
            }

            public void ungetService(IDeviceMappingParser service) {
            }
        };
        this.deviceMapper.addParser(this.cso, Map.of("sensinact.southbound.mapping.parser", "json"));
    }

    @AfterEach
    void stop() {
        this.deviceMapper.removeParser(this.cso, Map.of("sensinact.southbound.mapping.parser", "json"));
        this.deviceMapper = null;
        this.cso = null;
        this.bulks.clear();
    }

    byte[] readFile(String filename) throws IOException {
        try (InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(filename);){
            byte[] byArray = inStream.readAllBytes();
            return byArray;
        }
    }

    DeviceMappingConfigurationDTO readConfiguration(String filename) throws IOException {
        return (DeviceMappingConfigurationDTO)new ObjectMapper().readValue(this.readFile(filename), DeviceMappingConfigurationDTO.class);
    }

    GenericDto getResourceValue(String provider, String service, String resource) {
        for (BulkGenericDto bulk : this.bulks) {
            for (GenericDto dto : bulk.dtos) {
                if (!dto.provider.equals(provider) || !dto.service.equals(service) || !dto.resource.equals(resource)) continue;
                return dto;
            }
        }
        return null;
    }

    GenericDto checkModelPackageUri(String modelPackageUri) {
        for (BulkGenericDto bulk : this.bulks) {
            for (GenericDto dto : bulk.dtos) {
                Assertions.assertEquals((Object)modelPackageUri, (Object)dto.modelPackageUri);
            }
        }
        return null;
    }

    <T> T getResourceValue(String provider, String service, String resource, Class<T> rcType) {
        GenericDto dto = this.getResourceValue(provider, service, resource);
        if (dto != null && dto.value != null) {
            return rcType.cast(dto.value);
        }
        return null;
    }

    @Test
    void testLiteralMultipleObjects() throws Exception {
        String provider1 = "JsonLiteral1";
        String provider2 = "JsonLiteral2";
        DeviceMappingConfigurationDTO config = this.readConfiguration("json/literal-mapping.json");
        byte[] fileContent = this.readFile("json/literal.json");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        this.checkModelPackageUri("http://test.de");
        Assertions.assertEquals((int)94, (Integer)this.getResourceValue("JsonLiteral1", "data", "value", Integer.class));
        Assertions.assertEquals((int)28, (Integer)this.getResourceValue("JsonLiteral2", "data", "value", Integer.class));
        Assertions.assertEquals((Object)"Grenoble", (Object)this.getResourceValue("JsonLiteral1", "sensor", "city", String.class));
        Assertions.assertEquals((Object)"Grenoble", (Object)this.getResourceValue("JsonLiteral2", "sensor", "city", String.class));
        Assertions.assertEquals((Object)"Cours Berriat", (Object)this.getResourceValue("JsonLiteral1", "sensor", "street", String.class));
        Assertions.assertEquals((Object)"n/a", (Object)this.getResourceValue("JsonLiteral2", "sensor", "street", String.class));
    }

    @Test
    void testMultipleObjects() throws Exception {
        String provider1 = "JsonMultiple1";
        String provider2 = "JsonMultiple2";
        DeviceMappingConfigurationDTO config = this.readConfiguration("json/multiple-mapping.json");
        byte[] fileContent = this.readFile("json/multiple.json");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Assertions.assertEquals((int)94, (Integer)this.getResourceValue("JsonMultiple1", "data", "value", Integer.class));
        Assertions.assertEquals((int)28, (Integer)this.getResourceValue("JsonMultiple2", "data", "value", Integer.class));
        Instant timestamp1 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 14, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp1, (Object)this.getResourceValue((String)"JsonMultiple1", (String)"data", (String)"value").timestamp);
        Instant timestamp2 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 17, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp2, (Object)this.getResourceValue((String)"JsonMultiple2", (String)"data", (String)"value").timestamp);
        GenericDto location1 = this.getResourceValue("JsonMultiple1", "admin", "location");
        Assertions.assertEquals((Object)timestamp1, (Object)location1.timestamp);
        Assertions.assertNotNull((Object)location1.value);
        Point geoPoint = (Point)location1.value;
        Assertions.assertEquals((double)1.2, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)3.4, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
        GenericDto location2 = this.getResourceValue("JsonMultiple2", "admin", "location");
        Assertions.assertNotNull((Object)location2.value);
        Assertions.assertEquals((Object)timestamp2, (Object)location2.timestamp);
        geoPoint = (Point)location2.value;
        Assertions.assertEquals((double)5.6, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)7.8, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertEquals((double)1.5, (double)geoPoint.coordinates.elevation, (double)0.001);
    }

    @Test
    void testSubArray() throws Exception {
        String provider1 = "JsonSubArray1";
        String provider2 = "JsonSubArray2";
        String ignoredProvider = "JsonSubArray-Ignore";
        DeviceMappingConfigurationDTO config = this.readConfiguration("json/sub-array-mapping.json");
        byte[] fileContent = this.readFile("json/sub-array.json");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Assertions.assertEquals((int)94, (Integer)this.getResourceValue("JsonSubArray1", "data", "value", Integer.class));
        Assertions.assertEquals((int)28, (Integer)this.getResourceValue("JsonSubArray2", "data", "value", Integer.class));
        Instant timestamp1 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 14, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp1, (Object)this.getResourceValue((String)"JsonSubArray1", (String)"data", (String)"value").timestamp);
        Instant timestamp2 = Instant.from(LocalDateTime.of(2021, 10, 20, 18, 17, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp2, (Object)this.getResourceValue((String)"JsonSubArray2", (String)"data", (String)"value").timestamp);
        GenericDto location1 = this.getResourceValue("JsonSubArray1", "admin", "location");
        Assertions.assertEquals((Object)timestamp1, (Object)location1.timestamp);
        Assertions.assertNotNull((Object)location1.value);
        Point geoPoint = (Point)location1.value;
        Assertions.assertEquals((double)1.2, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)3.4, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
        GenericDto location2 = this.getResourceValue("JsonSubArray2", "admin", "location");
        Assertions.assertNotNull((Object)location2.value);
        Assertions.assertEquals((Object)timestamp2, (Object)location2.timestamp);
        geoPoint = (Point)location2.value;
        Assertions.assertEquals((double)5.6, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)7.8, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
        for (BulkGenericDto bulk : this.bulks) {
            for (GenericDto dto : bulk.dtos) {
                Assertions.assertNotEquals((Object)"JsonSubArray-Ignore", (Object)dto.provider);
            }
        }
    }

    @Test
    void testSingleObject() throws Exception {
        String provider = "JsonSingle1";
        DeviceMappingConfigurationDTO config = this.readConfiguration("json/multiple-mapping.json");
        byte[] fileContent = this.readFile("json/single.json");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Assertions.assertEquals((int)15, (Integer)this.getResourceValue("JsonSingle1", "data", "value", Integer.class));
        Assertions.assertEquals((long)1691587953000L, (Long)this.getResourceValue("JsonSingle1", "data", "long-value", Long.class));
        Instant timestamp = Instant.from(LocalDateTime.of(2022, 12, 7, 15, 17, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp, (Object)this.getResourceValue((String)"JsonSingle1", (String)"data", (String)"value").timestamp);
        GenericDto location = this.getResourceValue("JsonSingle1", "admin", "location");
        Assertions.assertEquals((Object)timestamp, (Object)location.timestamp);
        Assertions.assertNotNull((Object)location.value);
        Point geoPoint = (Point)location.value;
        Assertions.assertEquals((double)45.199, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)5.725, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertEquals((double)476.0, (double)geoPoint.coordinates.elevation);
    }

    @Test
    void testDatetime() throws Exception {
        String provider = "JsonDatetime";
        DeviceMappingConfigurationDTO config = this.readConfiguration("json/datetime-mapping.json");
        byte[] fileContent = this.readFile("json/datetime.json");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Instant timestamp = Instant.from(LocalDateTime.of(2022, 12, 7, 12, 1, 58).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp, (Object)this.getResourceValue((String)"JsonDatetime", (String)"data", (String)"value").timestamp);
    }

    @Test
    void testDeepObjects() throws Exception {
        String provider1 = "1452";
        String type1 = "GOOSE";
        String provider2 = "1851";
        String type2 = "DUCK";
        DeviceMappingConfigurationDTO config = this.readConfiguration("json/deep-multiple-mapping.json");
        byte[] fileContent = this.readFile("json/deep-multiple.json");
        this.deviceMapper.handle(config, Map.of(), fileContent);
        Assertions.assertEquals((int)0, (Integer)this.getResourceValue("1452", "data", "GOOSE-value", Integer.class));
        Instant timestamp = Instant.from(LocalDateTime.of(2021, 10, 26, 15, 28, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp, (Object)this.getResourceValue((String)"1452", (String)"data", (String)"GOOSE-value").timestamp);
        GenericDto location = this.getResourceValue("1452", "admin", "location");
        Assertions.assertEquals((Object)timestamp, (Object)location.timestamp);
        Assertions.assertNotNull((Object)location.value);
        System.out.println("Location value: " + location.value + " - " + location.value.getClass());
        Point geoPoint = (Point)location.value;
        Assertions.assertEquals((double)48.849577, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)2.350867, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
        Assertions.assertEquals((int)7, (Integer)this.getResourceValue("1851", "data", "DUCK-value", Integer.class));
        timestamp = Instant.from(LocalDateTime.of(2021, 10, 26, 15, 27, 0).atOffset(ZoneOffset.UTC));
        Assertions.assertEquals((Object)timestamp, (Object)this.getResourceValue((String)"1851", (String)"data", (String)"DUCK-value").timestamp);
        location = this.getResourceValue("1851", "admin", "location");
        Assertions.assertEquals((Object)timestamp, (Object)location.timestamp);
        Assertions.assertNotNull((Object)location.value);
        geoPoint = (Point)location.value;
        Assertions.assertEquals((double)48.858396, (double)geoPoint.coordinates.latitude, (double)0.001);
        Assertions.assertEquals((double)2.350484, (double)geoPoint.coordinates.longitude, (double)0.001);
        Assertions.assertTrue((boolean)Double.isNaN(geoPoint.coordinates.elevation));
    }
}

