/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.history.timescale;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.southbound.history.api.HistoricalQueries;
import org.eclipse.sensinact.gateway.southbound.history.timescale.TimedValueImpl;
import org.osgi.service.transaction.control.TransactionControl;
import org.osgi.service.typedevent.TypedEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimescaleDatabaseWorker
implements TypedEventHandler<ResourceDataNotification>,
HistoricalQueries {
    private static final String INSERT_TEMPLATE = "INSERT INTO %s ( time, modelpackageuri, model, provider, service, resource, data ) values ( ?, ?, ?, ?, ?, ?, %s );";
    private static final String SINGLE_TEMPLATE = "SELECT time, num, text, geo FROM ( ( SELECT time, data AS num, NULL AS text, NULL AS geo FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ORDER BY time DESC LIMIT 1 ) UNION ALL ( SELECT time, NULL AS num, data AS text, NULL AS geo FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ORDER BY time DESC LIMIT 1 ) UNION ALL ( SELECT time, NULL AS num, NULL AS text, ST_AsGeoJSON(data) AS geo FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ORDER BY time DESC LIMIT 1 ) ) results ORDER BY time DESC LIMIT 1;";
    private static final String SINGLE_TEMPLATE_WITHOUT_TIME = "SELECT time, num, text, geo FROM ( ( SELECT time, data AS num, NULL AS text, NULL AS geo FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? ORDER BY time ASC LIMIT 1 ) UNION ALL ( SELECT time, NULL AS num, data AS text, NULL AS geo FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? ORDER BY time ASC LIMIT 1 ) UNION ALL ( SELECT time, NULL AS num, NULL AS text, ST_AsGeoJSON(data) AS geo FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? ORDER BY time ASC LIMIT 1 ) ) results ORDER BY time DESC LIMIT 1;";
    private static final String RANGE_TEMPLATE = "SELECT time, num, text, geo FROM ( ( SELECT time, data AS num, NULL AS text, NULL AS geo FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? AND time >= ? ORDER BY time ASC ) UNION ALL ( SELECT time, NULL AS num, data AS text, NULL AS geo FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? AND time >= ? ORDER BY time ASC ) UNION ALL ( SELECT time, NULL AS num, NULL AS text, ST_AsGeoJSON(data) AS geo FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? AND time >= ? ORDER BY time ASC ) ) results ORDER BY time ASC OFFSET ? LIMIT 501;";
    private static final String RANGE_TEMPLATE_WITHOUT_LIMIT = "SELECT time, num, text, geo FROM ( ( SELECT time, data AS num, NULL AS text, NULL AS geo FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? AND time >= ? ORDER BY time ASC ) UNION ALL ( SELECT time, NULL AS num, data AS text, NULL AS geo FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? AND time >= ? ORDER BY time ASC ) UNION ALL ( SELECT time, NULL AS num, NULL AS text, ST_AsGeoJSON(data) AS geo FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? AND time >= ? ORDER BY time ASC ) ) results ORDER BY time ASC OFFSET ? LIMIT 501;";
    private static final String RANGE_TEMPLATE_WITHOUT_START = "SELECT reverse.* from ( SELECT time, num, text, geo FROM ( ( SELECT time, data AS num, NULL AS text, NULL AS geo FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ORDER BY time DESC ) UNION ALL ( SELECT time, NULL AS num, data AS text, NULL AS geo FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ORDER BY time DESC ) UNION ALL ( SELECT time, NULL AS num, NULL AS text, ST_AsGeoJSON(data) AS geo FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ORDER BY time DESC ) ) results ORDER BY time DESC OFFSET ? LIMIT 500 ) reverse ORDER BY time ASC;";
    private static final String RANGE_TEMPLATE_WITHOUT_START_OR_LIMIT = "SELECT reverse.* from ( SELECT time, num, text, geo FROM ( ( SELECT time, data AS num, NULL AS text, NULL AS geo FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? ORDER BY time DESC) UNION ALL ( SELECT time, NULL AS num, data AS text, NULL AS geo FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? ORDER BY time DESC ) UNION ALL ( SELECT time, NULL AS num, NULL AS text, ST_AsGeoJSON(data) AS geo FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? ORDER BY time DESC ) ) results ORDER BY time DESC OFFSET ? LIMIT 500 ) reverse ORDER BY time ASC;";
    private static final String COUNT_TEMPLATE = "SELECT SUM(c) FROM ( ( SELECT COUNT(time) as c FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? AND time >= ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? AND time >= ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? AND time >= ? ) ) results;";
    private static final String COUNT_TEMPLATE_WITHOUT_LIMIT = "SELECT SUM(c) FROM ( ( SELECT COUNT(time) as c FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? AND time >= ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? AND time >= ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? AND time >= ? ) ) results;";
    private static final String COUNT_TEMPLATE_WITHOUT_START = "SELECT SUM(c) FROM ( ( SELECT COUNT(time) as c FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? AND time <= ? ) ) results;";
    private static final String COUNT_TEMPLATE_WITHOUT_START_OR_LIMIT = "SELECT SUM(c) FROM ( ( SELECT COUNT(time) as c FROM sensinact.numeric_data WHERE provider = ? AND service = ? AND resource = ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.text_data WHERE provider = ? AND service = ? AND resource = ? ) UNION ALL ( SELECT COUNT(time) as c FROM sensinact.geo_data WHERE provider = ? AND service = ? AND resource = ? ) ) results;";
    private static final Logger logger = LoggerFactory.getLogger(TimescaleDatabaseWorker.class);
    private final TransactionControl txControl;
    private final Supplier<Connection> connectionSupplier;
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Set<Class<?>> primitiveNumbers = Set.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    public TimescaleDatabaseWorker(TransactionControl txControl, Supplier<Connection> connectionSupplier) {
        this.txControl = txControl;
        this.connectionSupplier = connectionSupplier;
    }

    public void notify(String topic, ResourceDataNotification event) {
        block19: {
            Object value;
            String command;
            if (logger.isDebugEnabled()) {
                logger.debug("Update received for topic {} and the data will be stored", (Object)topic);
            }
            if (this.isGeographic(event)) {
                String tmpValue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Event is geographic");
                }
                command = String.format(INSERT_TEMPLATE, "sensinact.geo_data", "(SELECT ST_GeomFromGeoJSON( ? )::geography)");
                if (event.newValue == null) {
                    tmpValue = "{\"type\":\"Point\", \"coordinates\":[]}";
                } else if (event.newValue instanceof GeoJsonObject) {
                    try {
                        if (event.newValue instanceof FeatureCollection) {
                            FeatureCollection featureCollection = (FeatureCollection)event.newValue;
                            List features = featureCollection.features;
                            if (features.isEmpty() || ((Feature)features.get((int)0)).geometry == null) {
                                tmpValue = "{\"type\":\"Point\", \"coordinates\":[]}";
                            }
                            tmpValue = this.mapper.writeValueAsString((Object)((Feature)features.get((int)0)).geometry);
                        }
                        tmpValue = this.mapper.writeValueAsString(event.newValue);
                    }
                    catch (JsonProcessingException e) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Unable to serialize geographic data for {}", (Object)topic, (Object)e);
                        }
                        return;
                    }
                } else {
                    tmpValue = event.newValue.toString();
                }
                value = tmpValue;
            } else if (this.isNumber(event.type)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Event is numeric");
                }
                command = String.format(INSERT_TEMPLATE, "sensinact.numeric_data", "?");
                value = event.newValue;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Event is being treated as text");
                }
                command = String.format(INSERT_TEMPLATE, "sensinact.text_data", "?");
                value = event.newValue == null ? null : event.newValue.toString();
            }
            Connection conn = this.connectionSupplier.get();
            try {
                this.txControl.required(() -> {
                    PreparedStatement ps = conn.prepareStatement(command);
                    ps.setTimestamp(1, Timestamp.from(event.timestamp));
                    ps.setString(2, event.modelPackageUri);
                    ps.setString(3, event.model);
                    ps.setString(4, event.provider);
                    ps.setString(5, event.service);
                    ps.setString(6, event.resource);
                    ps.setObject(7, value);
                    return ps.execute();
                });
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block19;
                logger.warn("Unable to store data for {}", (Object)topic, (Object)e);
            }
        }
    }

    private boolean isGeographic(ResourceDataNotification event) {
        return GeoJsonObject.class.isAssignableFrom(event.type);
    }

    private boolean isNumber(Class<?> type) {
        return primitiveNumbers.contains(type) || Number.class.isAssignableFrom(type);
    }

    public TimedValue<?> getSingleValue(String provider, String service, String resource, ZonedDateTime time) {
        Connection conn = this.connectionSupplier.get();
        try {
            return (TimedValue)this.txControl.required(() -> {
                PreparedStatement ps;
                if (time == null) {
                    ps = conn.prepareStatement(SINGLE_TEMPLATE_WITHOUT_TIME);
                    this.setVariables(ps, provider, service, resource);
                } else {
                    ps = conn.prepareStatement(SINGLE_TEMPLATE);
                    this.setVariables(ps, provider, service, resource, Timestamp.from(time == null ? Instant.now() : time.toInstant()));
                }
                ResultSet rs = ps.executeQuery();
                Object result = rs.next() ? this.toTimedValue(rs) : new TimedValueImpl<Object>(null, null);
                return result;
            });
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to locate data for {} {} {}", new Object[]{provider, service, resource, e});
            }
            throw new RuntimeException(e);
        }
    }

    private void setVariables(PreparedStatement ps, Object ... variables) throws SQLException {
        int idx = 1;
        for (int i = 0; i < 3; ++i) {
            for (Object o : variables) {
                ps.setObject(idx++, o);
            }
        }
    }

    private TimedValue<?> toTimedValue(ResultSet rs) throws Exception {
        Object value = null;
        Instant dataTime = rs.getTimestamp("time").toInstant();
        BigDecimal num = rs.getBigDecimal("num");
        if (num != null) {
            value = num.scale() <= 0 ? (Number)num.longValueExact() : (Number)num.doubleValue();
        } else {
            String text = rs.getString("text");
            if (text != null) {
                value = text;
            } else {
                String geo = rs.getString("geo");
                if (geo != null) {
                    value = this.mapper.readValue(geo, GeoJsonObject.class);
                }
            }
        }
        return new TimedValueImpl<Object>(value, dataTime);
    }

    public List<TimedValue<?>> getValueRange(String provider, String service, String resource, ZonedDateTime fromTime, ZonedDateTime toTime, Integer skip) {
        Integer toSkip = skip == null ? Integer.valueOf(0) : skip;
        Connection conn = this.connectionSupplier.get();
        try {
            return (List)this.txControl.required(() -> {
                PreparedStatement ps;
                ArrayList<Object> list = new ArrayList<Object>(501);
                if (toTime == null) {
                    if (fromTime == null) {
                        ps = conn.prepareStatement(RANGE_TEMPLATE_WITHOUT_START_OR_LIMIT);
                        this.setVariables(ps, provider, service, resource);
                        ps.setInt(10, toSkip);
                    } else {
                        ps = conn.prepareStatement(RANGE_TEMPLATE_WITHOUT_LIMIT);
                        this.setVariables(ps, provider, service, resource, Timestamp.from(fromTime.toInstant()));
                        ps.setInt(13, toSkip);
                    }
                } else if (fromTime == null) {
                    ps = conn.prepareStatement(RANGE_TEMPLATE_WITHOUT_START);
                    this.setVariables(ps, provider, service, resource, Timestamp.from(toTime.toInstant()));
                    ps.setInt(13, toSkip);
                } else {
                    ps = conn.prepareStatement(RANGE_TEMPLATE);
                    this.setVariables(ps, provider, service, resource, Timestamp.from(toTime.toInstant()), Timestamp.from(fromTime.toInstant()));
                    ps.setInt(16, toSkip);
                }
                ResultSet rs = ps.executeQuery();
                for (int i = 0; i < 500 && rs.next(); ++i) {
                    list.add(this.toTimedValue(rs));
                }
                if (rs.next()) {
                    list.add(new TimedValueImpl<Object>(null, null));
                }
                return list;
            });
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to locate data for {} {} {}", new Object[]{provider, service, resource, e});
            }
            throw new RuntimeException(e);
        }
    }

    public Long getStoredValueCount(String provider, String service, String resource, ZonedDateTime fromTime, ZonedDateTime toTime) {
        Connection conn = this.connectionSupplier.get();
        try {
            return (Long)this.txControl.required(() -> {
                PreparedStatement ps;
                if (toTime == null) {
                    if (fromTime == null) {
                        ps = conn.prepareStatement(COUNT_TEMPLATE_WITHOUT_START_OR_LIMIT);
                        this.setVariables(ps, provider, service, resource);
                    } else {
                        ps = conn.prepareStatement(COUNT_TEMPLATE_WITHOUT_LIMIT);
                        this.setVariables(ps, provider, service, resource, Timestamp.from(fromTime.toInstant()));
                    }
                } else if (fromTime == null) {
                    ps = conn.prepareStatement(COUNT_TEMPLATE_WITHOUT_START);
                    this.setVariables(ps, provider, service, resource, Timestamp.from(toTime.toInstant()));
                } else {
                    ps = conn.prepareStatement(COUNT_TEMPLATE);
                    this.setVariables(ps, provider, service, resource, Timestamp.from(toTime.toInstant()), Timestamp.from(fromTime.toInstant()));
                }
                ResultSet rs = ps.executeQuery();
                rs.next();
                return rs.getLong(1);
            });
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to count data for {} {} {}", new Object[]{provider, service, resource, e});
            }
            throw new RuntimeException(e);
        }
    }
}

