/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.factory.integration;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class KeyToolUtils {
    private final String execPath;

    public KeyToolUtils() throws Exception {
        Path javaBinDir = Paths.get(ProcessHandle.current().info().command().get(), new String[0]).getParent();
        Object tool = "keytool";
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            tool = (String)tool + ".exe";
        }
        this.execPath = javaBinDir.resolve((String)tool).toAbsolutePath().toString();
    }

    public int runTool(Object ... args) throws IOException {
        return this.runTool(null, null, args);
    }

    public int runTool(ProcessBuilder.Redirect input, ProcessBuilder.Redirect output, Object ... args) throws IOException {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(this.execPath);
        allArgs.addAll(Arrays.stream(args).map(Object::toString).collect(Collectors.toList()));
        ProcessBuilder builder = new ProcessBuilder(allArgs);
        if (input != null) {
            builder.redirectInput(input);
        }
        if (output != null) {
            builder.redirectOutput(output);
            builder.redirectErrorStream();
        }
        Process process = builder.start();
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            process.destroyForcibly();
            return 127;
        }
    }
}

