/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.mqtt.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.ChainedTrustManagers;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.MqttClientConfiguration;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.PEMUtils;

public class SSLUtils {
    public static final String PKCS12 = "PKCS12";

    private static void clearArray(char[] array) {
        if (array != null) {
            Arrays.fill(array, '\u0000');
        }
    }

    public static void loadKeyStore(MqttClientConfiguration config, CertKeys keys) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InvalidKeySpecException {
        String rawKeyStoreType = config.auth_keystore_type();
        String keystoreType = rawKeyStoreType != null ? rawKeyStoreType.strip() : PKCS12;
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        String keystorePath = config.auth_keystore_path();
        String clientCertPath = config.auth_clientcert_path();
        String clientKeyPath = config.auth_clientcert_key();
        if (keystorePath != null && !keystorePath.isBlank()) {
            String keystorePassword = config._auth_keystore_password();
            keys.keyPassword = keystorePassword != null ? keystorePassword.toCharArray() : null;
            try (FileInputStream inStream = new FileInputStream(keystorePath);){
                keyStore.load(inStream, keys.keyPassword);
            }
        }
        if (clientCertPath != null && !clientCertPath.isBlank() && clientKeyPath != null && !clientKeyPath.isBlank()) {
            Certificate clientCert;
            String clientKeyPassword = config._auth_clientcert_key_password();
            keys.keyPassword = clientKeyPassword != null ? clientKeyPassword.toCharArray() : null;
            keyStore.load(null, keys.keyPassword);
            if (keys.caCertificate != null) {
                keyStore.setCertificateEntry("ca", keys.caCertificate);
            }
            try (FileInputStream inStream = new FileInputStream(clientCertPath);){
                clientCert = PEMUtils.loadCertificate(inStream);
            }
            inStream = new FileInputStream(clientKeyPath);
            try {
                keyStore.setKeyEntry("client", PEMUtils.loadPrivateKey(inStream, config.auth_clientcert_key_algorithm()), keys.keyPassword, (Certificate[])List.of(clientCert, keys.caCertificate).stream().filter(Objects::nonNull).toArray(Certificate[]::new));
            }
            finally {
                inStream.close();
            }
        }
        throw new KeyStoreException("No client authentication configuration given");
        keys.keyStore = keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTrustStore(MqttClientConfiguration config, CertKeys keys) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String[] trustedCertificates;
        String caCertPath;
        FileInputStream inStream;
        String rawKeyStoreType = config.auth_truststore_type();
        String keystoreType = rawKeyStoreType != null ? rawKeyStoreType.strip() : PKCS12;
        KeyStore trustStore = KeyStore.getInstance(keystoreType);
        trustStore.load(null);
        String truststorePath = config.auth_truststore_path();
        if (truststorePath != null && !truststorePath.isBlank()) {
            char[] trustStorePassword = null;
            if (config._auth_truststore_password() != null) {
                trustStorePassword = config._auth_truststore_password().toCharArray();
            }
            try {
                inStream = new FileInputStream(truststorePath);
                try {
                    trustStore.load(inStream, trustStorePassword);
                }
                finally {
                    inStream.close();
                }
            }
            finally {
                SSLUtils.clearArray(trustStorePassword);
            }
        }
        if ((caCertPath = config.auth_clientcert_ca_path()) != null && !caCertPath.isBlank()) {
            inStream = new FileInputStream(caCertPath);
            try {
                Certificate caCert;
                keys.caCertificate = caCert = PEMUtils.loadCertificate(inStream);
                trustStore.setCertificateEntry("ca", caCert);
            }
            finally {
                inStream.close();
            }
        }
        if ((trustedCertificates = config.auth_trusted_certs()) != null && trustedCertificates.length > 0) {
            if (trustedCertificates.length == 1 && trustedCertificates[0].contains(",")) {
                trustedCertificates = trustedCertificates[0].split("\\s*,\\s*");
            }
            int i = 0;
            for (String path : trustedCertificates) {
                try (FileInputStream inStream2 = new FileInputStream(path);){
                    Certificate certificate = PEMUtils.loadCertificate(inStream2);
                    trustStore.setCertificateEntry("trusted-" + ++i, certificate);
                }
            }
        }
        keys.trustStore = trustStore;
    }

    public static SSLSocketFactory setupSSLSocketFactory(MqttClientConfiguration config) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException, InvalidKeySpecException {
        CertKeys keys = new CertKeys();
        try {
            SSLUtils.loadTrustStore(config, keys);
            SSLUtils.loadKeyStore(config, keys);
            SSLSocketFactory sSLSocketFactory = SSLUtils.setupSSLSocketFactory(keys, config.auth_truststore_default_merge(), config.auth_allow_expired());
            return sSLSocketFactory;
        }
        finally {
            SSLUtils.clearArray(keys.keyPassword);
        }
    }

    private static SSLSocketFactory setupSSLSocketFactory(CertKeys keys, boolean mergeDefaultTrustStore, boolean allowExpired) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        TrustManager[] trustManagers;
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keys.keyStore, keys.keyPassword);
        if (!keys.trustStore.aliases().hasMoreElements()) {
            keys.trustStore = keys.keyStore;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keys.trustStore);
        if (mergeDefaultTrustStore) {
            TrustManagerFactory defaultTmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            defaultTmf.init((KeyStore)null);
            trustManagers = new TrustManager[]{new ChainedTrustManagers(allowExpired, (TrustManager[][])new TrustManager[][]{tmf.getTrustManagers(), defaultTmf.getTrustManagers()})};
        } else {
            trustManagers = allowExpired ? new TrustManager[]{new ChainedTrustManagers(true, tmf.getTrustManagers())} : tmf.getTrustManagers();
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
        sslContext.init(kmf.getKeyManagers(), trustManagers, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    private static class CertKeys {
        private KeyStore trustStore;
        private Certificate caCertificate;
        private KeyStore keyStore;
        private char[] keyPassword;

        private CertKeys() {
        }
    }
}

