/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.remote;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.message.AbstractSnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessage;
import org.eclipse.sensinact.gateway.core.message.SnaRemoteMessageImpl;
import org.eclipse.sensinact.gateway.core.remote.MQTTURLExtract;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBase;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIFaceManager;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIface;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttBroker;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttTopic;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.listener.MqttTopicMessage;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensinactCoreBaseIFaceManagerImpl
implements SensinactCoreBaseIFaceManager {
    private static final Logger LOG = LoggerFactory.getLogger(SensinactCoreBaseIFaceManager.class);
    private ServiceTracker<SensinactCoreBaseIface, MqttBroker> tracker;
    private ServiceRegistration<?> registration;
    private ServiceRegistration<?> registrationConfiguration;
    private ServiceRegistration<?> registrationCoreBaseIface;
    private SensinactCoreBase sensinactCoreBase;
    protected volatile String namespace;
    private Mediator mediator;

    SensinactCoreBaseIFaceManagerImpl() {
    }

    public void start(Mediator mediator) {
        this.mediator = mediator;
        BundleContext context = mediator.getContext();
        this.registrationConfiguration = context.registerService(ConfigurationListener.class.getCanonicalName(), (Object)new SensinactCoreBaseIfaceConfigurationListener(), new Hashtable());
    }

    public void stop() {
        if (this.registrationConfiguration != null) {
            try {
                this.registrationConfiguration.unregister();
            }
            catch (IllegalStateException e) {
                LOG.debug(e.getMessage());
            }
            this.registrationConfiguration = null;
        }
        this.deactivateLocalSensinactCoreBaseIface();
    }

    private void activateLocalSensinactCoreBaseIface() {
        this.tracker = new ServiceTracker(this.mediator.getContext(), "org.eclipse.sensinact.gateway.core.api.SensinactCoreBaseIface", (ServiceTrackerCustomizer)new SensinactCoreBaseIFaceObserverCustomizer(this.mediator));
        this.tracker.open(true);
        this.registration = this.mediator.getContext().registerService(SensinactCoreBaseIFaceManager.class, (Object)this, null);
        this.sensinactCoreBase = new SensinactCoreBase(this.mediator, this.namespace);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.exported.interfaces", SensinactCoreBaseIface.class.getName());
        ((Dictionary)props).put("service.exported.configs", "aries.fastbin");
        ((Dictionary)props).put("org.eclipse.sensinact.remote.namespace", this.namespace);
        this.registrationCoreBaseIface = this.mediator.getContext().registerService(SensinactCoreBaseIface.class, (Object)this.sensinactCoreBase, props);
        this.sensinactCoreBase.activate();
    }

    private void deactivateLocalSensinactCoreBaseIface() {
        if (this.sensinactCoreBase != null) {
            this.sensinactCoreBase.deactivate();
        }
        if (this.registrationCoreBaseIface != null) {
            try {
                this.registrationCoreBaseIface.unregister();
            }
            catch (IllegalStateException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.registrationCoreBaseIface = null;
            this.sensinactCoreBase = null;
        }
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (IllegalStateException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.registration = null;
        }
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    final void notifyCallbacks(final SnaMessage<?> message) {
        this.mediator.callServices(SnaAgent.class, (Executable)new Executable<SnaAgent, Void>(){

            public Void execute(SnaAgent agent) throws Exception {
                agent.register(message);
                return null;
            }
        });
    }

    public String namespace() {
        return this.namespace;
    }

    private final class SensinactCoreBaseIfaceConfigurationListener
    implements ConfigurationListener {
        private SensinactCoreBaseIfaceConfigurationListener() {
        }

        public void configurationEvent(ConfigurationEvent event) {
            LOG.debug("Receiving Configuration notification for {}", (Object)event.getPid());
            if (event.getPid().equals("sensinact")) {
                Configuration confSensinact;
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)SensinactCoreBaseIFaceManagerImpl.this.mediator.getContext().getService(event.getReference());
                try {
                    confSensinact = configurationAdmin.getConfiguration("sensinact");
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return;
                }
                SensinactCoreBaseIFaceManagerImpl.this.deactivateLocalSensinactCoreBaseIface();
                switch (event.getType()) {
                    case 2: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        SensinactCoreBaseIFaceManagerImpl.this.namespace = String.valueOf(confSensinact.getProperties().get("namespace"));
                        LOG.info("SensiNact configuration is available, starting up SensiNact core with namespace {}..", (Object)SensinactCoreBaseIFaceManagerImpl.this.namespace);
                        SensinactCoreBaseIFaceManagerImpl.this.activateLocalSensinactCoreBaseIface();
                    }
                }
            }
        }
    }

    private final class SensinactCoreBaseIFaceObserverCustomizer
    implements ServiceTrackerCustomizer<SensinactCoreBaseIface, MqttBroker> {
        private final Mediator mediator;

        SensinactCoreBaseIFaceObserverCustomizer(Mediator mediator) {
            this.mediator = mediator;
        }

        public MqttBroker addingService(ServiceReference<SensinactCoreBaseIface> reference) {
            final String remoteNamespace = (String)reference.getProperty("org.eclipse.sensinact.remote.namespace");
            LOG.info("Receiving RSA discovery notification about remote instance {}", (Object)remoteNamespace);
            if (remoteNamespace.equals(SensinactCoreBaseIFaceManagerImpl.this.namespace())) {
                return null;
            }
            LOG.info("Connecting to RSA remote sensinact instance with namespace {}", (Object)remoteNamespace);
            String brokerAddr = this.mediator.getProperty("broker").toString();
            String brokerTopicPrefix = this.mediator.getProperty("broker.topic.prefix").toString();
            MQTTURLExtract mqttURL = new MQTTURLExtract(brokerAddr);
            MqttBroker mb = new MqttBroker.Builder().host(mqttURL.getHost()).port(mqttURL.getPort().intValue()).protocol(MqttBroker.Protocol.valueOf((String)mqttURL.getProtocol().toUpperCase())).build();
            MqttTopic topic = new MqttTopic(String.format("%s%s", brokerTopicPrefix, remoteNamespace), new MqttTopicMessage(){

                protected void messageReceived(String topic, String mqttMessage) {
                    LOG.info("Received remote notification from namespace {} on topic {} with message {}", new Object[]{remoteNamespace, topic, mqttMessage});
                    JSONObject event = new JSONObject(mqttMessage);
                    String path = event.getString("uri");
                    String provider = path.split("/")[1];
                    String uriTranslated = path.replaceFirst("/" + provider, String.format("/%s:%s", remoteNamespace, provider));
                    event.remove("uri");
                    event.put("uri", (Object)uriTranslated);
                    LOG.debug("Forwarding message received in local sensinact as {}", (Object)event.toString());
                    SnaMessage message = AbstractSnaMessage.fromJSON((Mediator)SensinactCoreBaseIFaceObserverCustomizer.this.mediator, (String)event.toString());
                    SensinactCoreBaseIFaceManagerImpl.this.notifyCallbacks(message);
                }
            });
            try {
                mb.subscribeToTopic(topic);
                mb.connect();
                SnaRemoteMessageImpl message = new SnaRemoteMessageImpl("/", SnaRemoteMessage.Remote.CONNECTED);
                message.setNotification(new JSONObject().append("namespace", (Object)remoteNamespace));
                SensinactCoreBaseIFaceManagerImpl.this.notifyCallbacks((SnaMessage<?>)message);
            }
            catch (Exception e) {
                LOG.error("Failed to connect to broker {}", (Object)brokerAddr, (Object)e);
            }
            return mb;
        }

        public void removedService(ServiceReference<SensinactCoreBaseIface> reference, MqttBroker service) {
            String key = (String)reference.getProperty("org.eclipse.sensinact.remote.namespace");
            LOG.info("Removing RSA sensinact remote instance {} from the pool", (Object)key.toString());
            try {
                service.disconnect();
                SnaRemoteMessageImpl message = new SnaRemoteMessageImpl("/", SnaRemoteMessage.Remote.DISCONNECTED);
                message.setNotification(new JSONObject().append("namespace", (Object)key));
                SensinactCoreBaseIFaceManagerImpl.this.notifyCallbacks((SnaMessage<?>)message);
            }
            catch (Exception e) {
                LOG.error("Failing disconnecting from broker {}", (Object)service.getHost());
            }
        }

        public void modifiedService(ServiceReference<SensinactCoreBaseIface> reference, MqttBroker service) {
            this.removedService(reference, service);
            this.addingService(reference);
        }
    }
}

