/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.user;

import java.security.InvalidKeyException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.User;
import org.eclipse.sensinact.gateway.core.security.UserKey;
import org.eclipse.sensinact.gateway.core.security.UserKeyBuilder;
import org.eclipse.sensinact.gateway.core.security.UserManager;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.util.CryptoUtils;

public class UserKeyBuilderImpl
implements UserKeyBuilder<Credentials, Credentials> {
    private Mediator mediator;

    public UserKeyBuilderImpl(Mediator mediator) {
        this.mediator = mediator;
    }

    public UserKey buildKey(Credentials credentials) throws InvalidKeyException, InvalidCredentialException, DataStoreException {
        if ("anonymous".equals(credentials.login) && "anonymous".equals(credentials.password)) {
            return null;
        }
        final String login = credentials.login;
        final String md5 = CryptoUtils.cryptWithMD5((String)credentials.password);
        User user = (User)this.mediator.callService(UserManager.class, (Executable)new Executable<UserManager, User>(){

            public User execute(UserManager manager) throws Exception {
                return manager.getUser(login, md5);
            }
        });
        if (user == null) {
            return null;
        }
        return new UserKey(user.getPublicKey());
    }
}

