/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.test;

import java.util.Dictionary;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.ModelElement;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModel;
import org.eclipse.sensinact.gateway.core.message.MessageRouter;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.security.AuthorizationService;
import org.eclipse.sensinact.gateway.core.security.UserKeyBuilder;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;

public class TestSecuredAccess {
    private static final String LOG_FILTER = "(objectClass=" + LogService.class.getCanonicalName() + ")";
    private static final String MESSAGE_HANDLER_FILTER = "(&(objectClass=" + MessageRouter.class.getCanonicalName() + ")(uri=/serviceProvider)";
    private static final String DATA_STORE_FILTER = "(objectClass=" + DataStoreService.class.getCanonicalName() + ")";
    private static final String AUTHENTICATION_FILTER = "(objectClass=" + UserKeyBuilder.class.getCanonicalName() + ")";
    private static final String AGENT_FILTER = "(objectClass=" + SnaAgent.class.getCanonicalName() + ")";
    private static final String AUTHORIZATION_FILTER = "(objectClass=" + AuthorizationService.class.getCanonicalName() + ")";
    private static final String MOCK_BUNDLE_NAME = "MockedBundle";
    private static final long MOCK_BUNDLE_ID = 1L;
    private final Filter filterHandler = (Filter)Mockito.mock(Filter.class);
    private final Filter filterAgent = (Filter)Mockito.mock(Filter.class);
    private final Filter filterDataStore = (Filter)Mockito.mock(Filter.class);
    private final Filter filterAuthentication = (Filter)Mockito.mock(Filter.class);
    private final Filter filterAuthorization = (Filter)Mockito.mock(Filter.class);
    private final BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
    private final Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
    private final ServiceReference<?> referenceHandler = (ServiceReference)Mockito.mock(ServiceReference.class);
    private final ServiceReference<?> referenceAgent = (ServiceReference)Mockito.mock(ServiceReference.class);
    private final ServiceRegistration<MessageRouter> registrationHandler = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
    private final ServiceRegistration<ModelElement> snaObjectRegistration = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
    private final ServiceReference<?> referenceAuthorization = (ServiceReference)Mockito.mock(ServiceReference.class);
    private final ServiceRegistration<Object> registration = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
    private final ServiceRegistration<SnaAgent> registrationAgent = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
    private final ServiceReference<Object> referenceProvider = (ServiceReference)Mockito.mock(ServiceReference.class);
    private SensiNactResourceModel provider;
    private MessageRouter handler;
    private SnaAgent agent;
    private int callbackCount;
    private int linkCallbackCount;
    private int agentCallbackCount;

    @BeforeEach
    public void init() throws InvalidServiceProviderException, InvalidSyntaxException {
        Filter filter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)filter.toString()).thenReturn((Object)LOG_FILTER);
        Mockito.when((Object)this.context.createFilter(LOG_FILTER)).thenReturn((Object)filter);
        Mockito.when((Object)this.context.getServiceReferences((String)Mockito.eq(null), (String)Mockito.eq((Object)LOG_FILTER))).thenReturn(null);
        Mockito.when((Object)this.context.getServiceReference(LOG_FILTER)).thenReturn(null);
        Mockito.when((Object)this.context.createFilter(MESSAGE_HANDLER_FILTER)).thenReturn((Object)this.filterHandler);
        Mockito.when((Object)this.filterHandler.toString()).thenReturn((Object)MESSAGE_HANDLER_FILTER);
        Mockito.when((Object)this.context.createFilter(AGENT_FILTER)).thenReturn((Object)this.filterAgent);
        Mockito.when((Object)this.filterAgent.toString()).thenReturn((Object)AGENT_FILTER);
        Mockito.when((Object)this.context.createFilter(DATA_STORE_FILTER)).thenReturn((Object)this.filterDataStore);
        Mockito.when((Object)this.filterDataStore.toString()).thenReturn((Object)DATA_STORE_FILTER);
        Mockito.when((Object)this.context.createFilter(AUTHENTICATION_FILTER)).thenReturn((Object)this.filterAuthentication);
        Mockito.when((Object)this.filterAuthentication.toString()).thenReturn((Object)AUTHENTICATION_FILTER);
        Mockito.when((Object)this.context.createFilter(AUTHORIZATION_FILTER)).thenReturn((Object)this.filterAuthorization);
        Mockito.when((Object)this.filterAuthorization.toString()).thenReturn((Object)AUTHORIZATION_FILTER);
        Mockito.when((Object)this.filterAuthorization.match(this.referenceAuthorization)).thenReturn((Object)true);
        Mockito.when((Object)this.context.getServiceReferences(Mockito.anyString(), Mockito.anyString())).then((Answer)new Answer<ServiceReference<?>[]>(){

            public ServiceReference<?>[] answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 2) {
                    return null;
                }
                if (arguments[0] != null && arguments[0].equals(MessageRouter.class.getCanonicalName()) && arguments[1] != null && arguments[1].equals("(uri=/serviceProvider)")) {
                    if (TestSecuredAccess.this.handler == null) {
                        return null;
                    }
                    return new ServiceReference[]{TestSecuredAccess.this.referenceHandler};
                }
                if (arguments[0] != null && arguments[0].equals(SnaAgent.class.getCanonicalName())) {
                    if (TestSecuredAccess.this.agent == null) {
                        return null;
                    }
                    return new ServiceReference[]{TestSecuredAccess.this.referenceAgent};
                }
                if (arguments[0] != null && arguments[0].equals(SensiNactResourceModel.class.getCanonicalName()) && arguments[1] != null && arguments[1].equals("(uri=/serviceProvider)")) {
                    return new ServiceReference[]{TestSecuredAccess.this.referenceProvider};
                }
                if (arguments[0] != null && arguments[0].equals(AuthorizationService.class.getCanonicalName()) && arguments[1] == null || arguments[0] == null && arguments[1].equals(AUTHORIZATION_FILTER)) {
                    return new ServiceReference[]{TestSecuredAccess.this.referenceAuthorization};
                }
                return null;
            }
        });
        Mockito.when((Object)this.context.getService((ServiceReference)Mockito.any(ServiceReference.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 1) {
                    return null;
                }
                if (arguments[0] == TestSecuredAccess.this.referenceAgent) {
                    return TestSecuredAccess.this.agent;
                }
                if (arguments[0] == TestSecuredAccess.this.referenceHandler) {
                    return TestSecuredAccess.this.handler;
                }
                if (arguments[0] == TestSecuredAccess.this.referenceProvider) {
                    return TestSecuredAccess.this.provider;
                }
                return null;
            }
        });
        Mockito.when((Object)this.context.registerService((String)Mockito.eq((Object)MessageRouter.class.getCanonicalName()), Mockito.any(MessageRouter.class), (Dictionary)Mockito.any(Dictionary.class))).thenAnswer((Answer)new Answer<ServiceRegistration<MessageRouter>>(){

            public ServiceRegistration<MessageRouter> answer(InvocationOnMock invocation) throws Throwable {
                return TestSecuredAccess.this.registrationHandler;
            }
        });
        Mockito.when((Object)this.context.registerService((String)Mockito.eq((Object)SnaAgent.class.getCanonicalName()), Mockito.any(SnaAgent.class), (Dictionary)Mockito.any(Dictionary.class))).thenAnswer((Answer)new Answer<ServiceRegistration<SnaAgent>>(){

            public ServiceRegistration<SnaAgent> answer(InvocationOnMock invocation) throws Throwable {
                return TestSecuredAccess.this.registrationAgent;
            }
        });
        Mockito.when((Object)this.context.registerService((String[])Mockito.any(String[].class), Mockito.any(SnaAgent.class), (Dictionary)Mockito.any(Dictionary.class))).thenAnswer((Answer)new Answer<ServiceRegistration<SnaAgent>>(){

            public ServiceRegistration<SnaAgent> answer(InvocationOnMock invocation) throws Throwable {
                return TestSecuredAccess.this.registrationAgent;
            }
        });
        Mockito.when((Object)this.context.registerService((String)Mockito.eq((Object)SensiNactResourceModel.class.getCanonicalName()), Mockito.any(ModelElement.class), (Dictionary)Mockito.any(Dictionary.class))).thenAnswer((Answer)new Answer<ServiceRegistration<ModelElement>>(){

            public ServiceRegistration<ModelElement> answer(InvocationOnMock invocation) throws Throwable {
                return TestSecuredAccess.this.snaObjectRegistration;
            }
        });
        Mockito.when((Object)this.registration.getReference()).thenReturn(this.referenceProvider);
        Mockito.when((Object)this.registrationHandler.getReference()).thenReturn(this.referenceHandler);
        Mockito.when((Object)this.registrationAgent.getReference()).thenReturn(this.referenceAgent);
        Mockito.when((Object)this.filterHandler.match(this.referenceHandler)).thenReturn((Object)true);
        Mockito.when((Object)this.context.getBundle()).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.bundle.getSymbolicName()).thenReturn((Object)MOCK_BUNDLE_NAME);
        Mockito.when((Object)this.bundle.getBundleId()).thenReturn((Object)1L);
        this.callbackCount = 0;
        this.linkCallbackCount = 0;
    }
}

