/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.oauth2;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.sensinact.gateway.security.oauth2.JWT;
import org.eclipse.sensinact.gateway.security.oauth2.OpenIDServer;
import org.eclipse.sensinact.gateway.security.oauth2.UserInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenID
extends JWT
implements UserInfo {
    String id_token;
    boolean validity;
    public int level;
    OpenIDServer OIDC;

    public OpenID(OpenIDServer OIDC, String data) throws JSONException, IOException {
        super(data, OIDC.getPublicKey());
        this.OIDC = OIDC;
        this.id_token = data;
        boolean result = false;
        Iterator it = this.keys();
        while (it.hasNext()) {
            String auditors;
            String elem = String.valueOf(it.next());
            if (elem.equals("exp")) {
                long currentTime;
                int expiration = super.getInt(elem);
                boolean bl = result = (long)expiration > (currentTime = System.currentTimeMillis() / 1000L);
                if (!result) {
                    System.out.println("Data expired " + expiration + " / " + currentTime);
                }
            }
            if (elem.equals("aud") && !(result = (auditors = this.getString(elem)).contains(OIDC.getClientId()))) {
                System.out.println("Bad client Id " + auditors + " / " + OIDC.getClientId());
            }
            this.validity = result;
        }
    }

    public OpenID() {
    }

    public OpenID(JSONObject object) {
        super(object);
    }

    @Override
    public boolean isValid() {
        if (super.isValid()) {
            return this.validity;
        }
        return false;
    }

    public void add(String name, String value) {
        try {
            if (this.has(name)) {
                this.remove(name);
            }
            this.append(name, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String token() {
        return this.id_token;
    }

    @Override
    public boolean hasRole(String role) {
        boolean result;
        block4: {
            result = false;
            if (role.equalsIgnoreCase((String)defaultRoles.get(0))) {
                return true;
            }
            try {
                if (!this.has("roles")) break block4;
                JSONArray roles = this.getJSONArray("roles");
                for (int i = 0; i < roles.length(); ++i) {
                    if (!roles.getString(i).equals(role)) continue;
                    result = true;
                    break;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public boolean check(String token) {
        try {
            String previous = this.getString("access_token");
            if (previous == null) {
                this.add("access_token", token);
                return true;
            }
            return previous.equals(token);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void dispose() {
        this.remove("access_token");
    }

    @Override
    public boolean expire() {
        return false;
    }
}

