/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.oauth2.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.sensinact.gateway.security.oauth2.IdentityServer;
import org.eclipse.sensinact.gateway.security.oauth2.OAuthServer;
import org.eclipse.sensinact.gateway.security.oauth2.UserInfo;

@WebFilter
public class SecurityFilter
implements Filter {
    private IdentityServer idServer;
    private OAuthServer authServer;

    public SecurityFilter(IdentityServer idServer, OAuthServer authServer) {
        this.idServer = idServer;
        this.authServer = authServer;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession();
        String token = (String)session.getAttribute("token");
        String authorization = request.getHeader("Authorization");
        boolean authorizationExists = authorization != null;
        boolean tokenExists = token != null && token.length() > 0;
        try {
            if (token == null && authorizationExists) {
                if (authorization.matches("^Bearer .*")) {
                    token = authorization.substring(7);
                }
                if (authorization.matches("^Basic .*")) {
                    token = this.authServer.basicToken((ServletRequest)request, authorization);
                }
                boolean bl = tokenExists = token != null && token.length() > 0;
            }
            if (tokenExists) {
                UserInfo user = this.authServer.check(token);
                if (user != null && this.idServer.check(user, (ServletRequest)request)) {
                    request.setAttribute("token", (Object)token);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                session.setAttribute("token", null);
                response.sendError(401, "unauthorized");
                return;
            }
            UserInfo user = this.authServer.anonymous();
            if (user != null && this.idServer.check(user, (ServletRequest)request)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (authorizationExists) {
                session.setAttribute("token", null);
                response.sendError(401, "unauthorized");
            } else if (this.authServer.handleSecurity((ServletRequest)request, (ServletResponse)response)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

