/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.oauth2.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.sensinact.gateway.security.oauth2.IdentityServer;
import org.eclipse.sensinact.gateway.security.oauth2.OAuthServer;
import org.eclipse.sensinact.gateway.security.oauth2.UserInfo;
import org.json.JSONObject;

@WebServlet
public class SecurityServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private IdentityServer idServer;
    private OAuthServer authServer;

    public SecurityServlet(IdentityServer idServer, OAuthServer authServer) {
        this.authServer = authServer;
        this.idServer = idServer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doExecute(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doExecute(req, resp);
    }

    private final void doExecute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        String code = request.getParameter("code");
        if (code != null) {
            int status = 401;
            HttpSession session = request.getSession();
            JSONObject tokens = this.authServer.verify(code, (ServletRequest)request);
            if (tokens != null) {
                try {
                    String id_token = tokens.getString("id_token");
                    String access_token = tokens.getString("access_token");
                    UserInfo user = this.idServer.getUserInfo(id_token, access_token);
                    this.authServer.addCredentials(access_token, user);
                    session.setAttribute("token", (Object)access_token);
                    status = 200;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                session.setAttribute("token", (Object)"");
            }
            response.setStatus(status);
            String uri = (String)session.getAttribute("redirect_uri");
            if (uri != null) {
                response.sendRedirect(uri);
            }
        }
    }
}

