/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.oauth2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.sensinact.gateway.security.oauth2.IdentityServer;
import org.eclipse.sensinact.gateway.security.oauth2.UserInfo;

abstract class IdentityServerWrapper
implements IdentityServer {
    static Hashtable<String, List<Pattern>> describe = new Hashtable();
    static Hashtable<String, List<Pattern>> read = new Hashtable();
    static Hashtable<String, List<Pattern>> write = new Hashtable();
    static Hashtable<String, List<Pattern>> create = new Hashtable();
    static Hashtable<String, List<Pattern>> get = new Hashtable();
    static Hashtable<String, List<Pattern>> post = new Hashtable();
    static Hashtable<String, List<Pattern>> put = new Hashtable();
    static Hashtable<String, List<Pattern>> delete = new Hashtable();
    static final Hashtable<String, Hashtable<String, List<Pattern>>> actions = new Hashtable<String, Hashtable<String, List<Pattern>>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("DESCRIBE", describe);
            this.put("READ", read);
            this.put("WRITE", write);
            this.put("CREATE", create);
            this.put("GET", get);
            this.put("POST", post);
            this.put("PUT", put);
            this.put("DELETE", delete);
        }
    };

    IdentityServerWrapper() {
    }

    @Override
    public int register(String role, String action, Pattern pattern) {
        Hashtable<String, List<Pattern>> table = actions.get(action);
        if (table != null) {
            List<Pattern> list = table.get(role);
            if (list == null) {
                list = new ArrayList<Pattern>();
                table.put(role, list);
            }
            list.add(pattern);
        }
        return 0;
    }

    @Override
    public int register(String role, String action, URI resource) {
        Hashtable<String, List<Pattern>> table = actions.get(action);
        if (table != null) {
            Pattern pattern = Pattern.compile(resource.toString());
            List<Pattern> list = table.get(role);
            if (list == null) {
                list = new ArrayList<Pattern>();
                table.put(role, list);
            }
            list.add(pattern);
        }
        return 0;
    }

    @Override
    public void unregister(int id) {
    }

    private boolean checkPattern(UserInfo user, List<Pattern> search, String needle) {
        if (search == null || search.isEmpty()) {
            return false;
        }
        Iterator<Pattern> it = search.iterator();
        while (it.hasNext()) {
            Matcher matcher = it.next().matcher(needle);
            while (matcher.find()) {
                boolean result = false;
                try {
                    String userreg = matcher.group("user");
                    String groupreg = matcher.group("group");
                    String rolereg = matcher.group("role");
                    if (userreg != null) {
                        if (userreg.equals(user.get("name"))) {
                            result = true;
                        }
                    } else if (groupreg != null) {
                        if (groupreg.equals(user.get("group"))) {
                            result = true;
                        }
                    } else if (rolereg != null) {
                        if (user.roles().contains(rolereg)) {
                            result = true;
                        }
                    } else {
                        result = true;
                    }
                    if (!result) continue;
                    return true;
                }
                catch (Exception e) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean check(UserInfo user, ServletRequest request) {
        if (user == null) {
            return false;
        }
        if (user.roles().contains(UserInfo.defaultRoles.get(4))) {
            return true;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        String method = req.getMethod();
        Hashtable<String, List<Pattern>> table = actions.get(method);
        if (table == null || table.isEmpty()) {
            return false;
        }
        try {
            URI uri = new URI(req.getRequestURI());
            String needle = uri.parseServerAuthority().toString();
            String role2 = UserInfo.defaultRoles.get(0);
            if (this.checkPattern(user, table.get(role2), needle)) {
                return true;
            }
            for (String role2 : user.roles()) {
                if (!this.checkPattern(user, table.get(role2), needle)) continue;
                return true;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return false;
    }
}

