/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.oauth2;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.eclipse.sensinact.gateway.security.oauth2.IdentityServerWrapper;
import org.eclipse.sensinact.gateway.security.oauth2.OAuthServer;
import org.eclipse.sensinact.gateway.security.oauth2.OpenID;
import org.eclipse.sensinact.gateway.security.oauth2.UserInfo;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class OpenIDServer
extends IdentityServerWrapper
implements OAuthServer {
    private Hashtable<String, UserInfo> credentials;
    UserInfo anonymous = new OpenID();
    URI authEP;
    URI tokenEP;
    URI userinfoEP;
    String publicKey;
    String client_id;
    String client_secret;
    String issuer;
    StringBuilder returnToUrl;
    String localAuth;
    Properties properties;

    public OpenIDServer(BundleContext context, String configfile) {
        String discoveryURL = null;
        String certsURL = null;
        try {
            Bundle[] bundles;
            this.properties = new Properties();
            this.properties.load(new FileInputStream(configfile));
            discoveryURL = this.properties.getProperty("discoveryURL").toString();
            certsURL = this.properties.getProperty("certsURL");
            this.client_id = this.properties.getProperty("client_id").toString();
            this.client_secret = this.properties.getProperty("client_secret").toString();
            for (Bundle bundle : bundles = context.getBundles()) {
                this.checkBundle(bundle);
            }
            context.addBundleListener(new BundleListener(){

                public void bundleChanged(BundleEvent e) {
                    OpenIDServer.this.checkBundle(e.getBundle());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.credentials = new Hashtable();
        this.localAuth = System.getProperty("org.eclipse.sensinact.gateway.auth.server.baseurl", "/sensinact.auth");
        try {
            ConnectionConfigurationImpl conf = new ConnectionConfigurationImpl();
            conf.setHttpMethod("GET");
            conf.setAccept("application/json");
            conf.setUri(discoveryURL.toString());
            SimpleResponse response = (SimpleResponse)new SimpleRequest((ConnectionConfiguration)conf).send();
            int status = response.getStatusCode();
            if (status == 200) {
                JSONObject jsonObject = new JSONObject(new String(response.getContent(), "UTF-8"));
                this.authEP = new URI(jsonObject.getString("authorization_endpoint"));
                this.tokenEP = new URI(jsonObject.getString("token_endpoint"));
                this.userinfoEP = new URI(jsonObject.getString("userinfo_endpoint"));
                this.issuer = jsonObject.getString("issuer");
            }
            conf = new ConnectionConfigurationImpl();
            conf.setHttpMethod("GET");
            conf.setAccept("application/json");
            conf.setUri(certsURL.toString());
            response = (SimpleResponse)new SimpleRequest((ConnectionConfiguration)conf).send();
            status = response.getStatusCode();
            if (status == 200) {
                JSONArray array = new JSONObject(new String(response.getContent(), "UTF-8")).getJSONArray("keys");
                JSONObject keys = array.getJSONObject(0);
                this.publicKey = keys.getString("n") + "." + keys.getString("e");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkBundle(Bundle bundle) {
        String bundlename = bundle.getSymbolicName();
        String bundleconfig = this.properties.getProperty(bundlename);
        if (bundleconfig != null) {
            String[] configs = bundleconfig.split(":");
            this.register(configs[0], configs[1], Pattern.compile(configs[2]));
        }
        int i = 0;
        bundleconfig = this.properties.getProperty(bundlename + "[" + i + "]");
        while (bundleconfig != null) {
            String[] configs = bundleconfig.split(":");
            this.register(configs[0], configs[1], Pattern.compile(configs[2]));
            bundleconfig = this.properties.getProperty(bundlename + "[" + ++i + "]");
        }
        try {
            String[] configs;
            Properties properties2 = new Properties();
            FileInputStream input = new FileInputStream("cfgs/" + bundlename + ".config");
            properties2.load(input);
            bundleconfig = properties2.getProperty("securityfilter");
            if (bundleconfig != null) {
                configs = bundleconfig.split(":");
                this.register(configs[0], configs[1], Pattern.compile(configs[2]));
            }
            i = 0;
            bundleconfig = properties2.getProperty("securityfilter[" + i + "]");
            while (bundleconfig != null) {
                configs = bundleconfig.split(":");
                this.register(configs[0], configs[1], Pattern.compile(configs[2]));
                bundleconfig = properties2.getProperty("securityfilter[" + ++i + "]");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getClientId() {
        return this.client_id;
    }

    String getClientSecret() {
        return this.client_secret;
    }

    String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JSONObject verify(String code, ServletRequest req) {
        JSONObject jsonObject = null;
        ConnectionConfigurationImpl conf = new ConnectionConfigurationImpl();
        conf.setHttpMethod("POST");
        conf.setContentType("application/x-www-form-urlencoded");
        try {
            conf.setUri(this.tokenEP.toURL().toExternalForm());
            String credentials = new String(this.client_id + ":" + this.client_secret);
            String basic = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            conf.addHeader("Authorization", "Basic " + basic);
            StringBuilder urlParameters = new StringBuilder();
            if (this.returnToUrl == null) {
                this.returnToUrl = new StringBuilder().append(req.getScheme()).append("://").append(req.getServerName()).append(":").append(req.getServerPort()).append(this.localAuth);
            }
            urlParameters.append("redirect_uri=");
            urlParameters.append(this.returnToUrl.toString());
            urlParameters.append("&client_id=");
            urlParameters.append(this.client_id);
            urlParameters.append("&code=");
            urlParameters.append(code);
            urlParameters.append("&scope=openid%20roles");
            urlParameters.append("&grant_type=authorization_code");
            urlParameters.append("&response_type=id_token%20token");
            conf.setContent((Object)urlParameters.toString());
            String access_token = null;
            try {
                SimpleResponse response = (SimpleResponse)new SimpleRequest((ConnectionConfiguration)conf).send();
                int status = response.getStatusCode();
                if (status == 200) {
                    jsonObject = new JSONObject(new String(response.getContent(), "UTF-8"));
                    access_token = jsonObject.getString("access_token");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (access_token != null) {
                return jsonObject;
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean handleSecurity(ServletRequest request, ServletResponse response) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.localAuth.equals(req.getPathInfo())) {
            return true;
        }
        try {
            this.returnToUrl = new StringBuilder().append(req.getScheme()).append("://").append(req.getServerName()).append(":").append(req.getServerPort()).append(this.localAuth);
            StringBuilder builder = new StringBuilder().append(this.authEP.getScheme()).append("://").append(this.authEP.getHost()).append(":").append(this.authEP.getPort()).append(this.authEP.getPath()).append("?").append("redirect_uri").append("=").append(this.returnToUrl.toString()).append("&").append("client_id").append("=").append(this.client_id).append("&").append("scope").append("=").append("openid%20profile%20roles").append("&").append("response_type").append("=").append("code");
            res.sendRedirect(builder.toString());
            HttpSession session = req.getSession();
            session.setAttribute("redirect_uri", (Object)req.getRequestURI());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public UserInfo check(String access_token) throws IOException {
        OpenID found = (OpenID)this.credentials.get(access_token);
        if (found != null) {
            return found;
        }
        try {
            found = new OpenID(this, access_token);
            if (found.isValid()) {
                return found;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String basicToken(ServletRequest request, String authorization) {
        try {
            ConnectionConfigurationImpl conf = new ConnectionConfigurationImpl();
            conf.setHttpMethod("POST");
            conf.setContentType("application/x-www-form-urlencoded");
            conf.setUri(this.tokenEP.toURL().toExternalForm());
            String credentials = new String(this.client_id + ":" + this.client_secret);
            String basic = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            conf.addHeader("Authorization", "Basic " + basic);
            StringBuilder urlParameters = new StringBuilder();
            HttpServletRequest req = (HttpServletRequest)request;
            if (this.returnToUrl == null) {
                this.returnToUrl = new StringBuilder().append(req.getScheme()).append("://").append(req.getServerName()).append(":").append(req.getServerPort()).append(this.localAuth);
            }
            String credentialsStr = new String(Base64.getDecoder().decode(authorization.substring(6)));
            String[] credentialsArr = credentialsStr.split(":");
            String username = credentialsArr[0];
            String password = credentialsArr[1];
            urlParameters.append("redirect_uri=");
            urlParameters.append(this.returnToUrl.toString());
            urlParameters.append("&client_id=");
            urlParameters.append(this.client_id);
            urlParameters.append("&username=");
            urlParameters.append(username);
            urlParameters.append("&password=");
            urlParameters.append(password);
            urlParameters.append("&scope=openid%20roles");
            urlParameters.append("&grant_type=password");
            urlParameters.append("&response_type=id_token%20token");
            conf.setContent((Object)urlParameters.toString());
            SimpleResponse response = (SimpleResponse)new SimpleRequest((ConnectionConfiguration)conf).send();
            int status = response.getStatusCode();
            if (status == 200) {
                JSONObject obj = new JSONObject(new String(response.getContent(), "UTF-8"));
                return obj.getString("access_token");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public UserInfo anonymous() {
        return this.anonymous;
    }

    @Override
    public void addCredentials(String token, UserInfo newUser) {
        ((OpenID)newUser).add("access_token", token);
        this.credentials.put(token, newUser);
    }

    @Override
    public UserInfo getUserInfo(String token, String authorization) {
        OpenID user = null;
        try {
            ConnectionConfigurationImpl conf = new ConnectionConfigurationImpl();
            conf.setHttpMethod("GET");
            conf.setUri(this.userinfoEP.toURL().toExternalForm() + "?client_id=" + this.client_id);
            conf.addHeader("Authorization", "Bearer " + authorization);
            SimpleResponse response = (SimpleResponse)new SimpleRequest((ConnectionConfiguration)conf).send();
            String resp = new String(response.getContent(), "UTF-8");
            int status = response.getStatusCode();
            if (status == 200) {
                JSONObject jsonObject = new JSONObject(resp);
                user = new OpenID(jsonObject);
                Iterator it = jsonObject.keys();
                while (it.hasNext()) {
                    String key = String.valueOf(it.next());
                    user.put(key, jsonObject.get(key));
                }
            } else {
                System.out.println(this.userinfoEP + " response : " + status);
                System.out.println(response.getHeaders());
                System.out.println("error " + resp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return user;
    }

    @Override
    public boolean check(UserInfo user, ServletRequest request) {
        return super.check(user, request);
    }
}

