/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.user.openid;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.time.Instant;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.sensinact.gateway.core.security.user.openid.KeyCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonWebToken {
    private static final String ALGORITHM_KEY = "alg";
    private static final Logger LOG = LoggerFactory.getLogger(JsonWebToken.class);
    private final String token;
    private final Map<String, Object> payload;
    private final boolean isValid;

    public JsonWebToken(String plainToken) {
        boolean valid;
        Map payload;
        this.token = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            payload = (Map)mapper.readValue(plainToken, (TypeReference)new TypeReference<Map<String, Object>>(){});
            valid = true;
        }
        catch (IOException e) {
            LOG.error("Unable to read the JWT payload", (Throwable)e);
            payload = Collections.emptyMap();
            valid = false;
        }
        this.payload = payload;
        this.isValid = valid;
    }

    public JsonWebToken(String data, List<KeyCollection.Keys> keys) {
        Map parsedPayload;
        Map headerMap;
        this.token = data;
        ObjectMapper mapper = new ObjectMapper();
        Base64.Decoder decoder = Base64.getDecoder();
        Base64.Encoder encoder = Base64.getEncoder();
        int part1 = data.indexOf(".");
        int part2 = data.lastIndexOf(".");
        String header = data.substring(0, part1);
        while ((4 - header.length() % 4) % 4 != 0) {
            header = header.concat("=");
        }
        header = header.replace("-", "+");
        header = header.replace("_", "/");
        header = new String(decoder.decode(header));
        try {
            headerMap = (Map)mapper.readValue(header, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            LOG.error("Unable to read the JWT header", (Throwable)e);
            this.payload = Collections.emptyMap();
            this.isValid = false;
            return;
        }
        String payload = data.substring(part1 + 1, part2);
        while ((4 - payload.length() % 4) % 4 != 0) {
            payload = payload.concat("=");
        }
        payload = payload.replace("-", "+");
        payload = payload.replace("_", "/");
        payload = new String(decoder.decode(payload));
        boolean result = false;
        try {
            String algorithm;
            String signature = new String(data.substring(part2 + 1).getBytes("UTF-8"));
            while ((4 - signature.length() % 4) % 4 != 0) {
                signature = signature.concat("=");
            }
            signature = signature.replace("-", "+");
            signature = signature.replace("_", "/");
            byte[] signatureBytes = decoder.decode(signature);
            String b64header = encoder.encodeToString(header.getBytes("UTF-8"));
            b64header = b64header.split("=")[0];
            b64header = b64header.replace('+', '-');
            b64header = b64header.replace('/', '_');
            String b64payload = encoder.encodeToString(payload.getBytes("UTF-8"));
            b64payload = b64payload.split("=")[0];
            b64payload = b64payload.replace('+', '-');
            b64payload = b64payload.replace('/', '_');
            String testdata = b64header + "." + b64payload;
            switch (algorithm = String.valueOf(headerMap.get(ALGORITHM_KEY))) {
                case "RS256": {
                    KeyCollection.Keys ki = keys.stream().filter(k -> "RSA".equals(k.getType()) && "RS256".equals(k.getAlgorithm())).findFirst().orElse(null);
                    if (ki == null) {
                        throw new GeneralSecurityException("No suitable key to decrypt RS256");
                    }
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    Signature sig = Signature.getInstance("SHA256withRSA");
                    String modulusBase64 = ki.getRsaModulus();
                    while ((4 - modulusBase64.length() % 4) % 4 != 0) {
                        modulusBase64 = modulusBase64.concat("=");
                    }
                    modulusBase64 = modulusBase64.replace("-", "+");
                    modulusBase64 = modulusBase64.replace("_", "/");
                    byte[] modulusBase64Bytes = decoder.decode(modulusBase64);
                    String exponentBase64 = ki.getRsaExponent();
                    while ((4 - exponentBase64.length() % 4) % 4 != 0) {
                        exponentBase64 = exponentBase64.concat("=");
                    }
                    exponentBase64 = exponentBase64.replace("-", "+");
                    exponentBase64 = exponentBase64.replace("_", "/");
                    byte[] exponentBase64Bytes = decoder.decode(exponentBase64);
                    BigInteger modulus = new BigInteger(1, modulusBase64Bytes);
                    BigInteger publicExponent = new BigInteger(1, exponentBase64Bytes);
                    PublicKey pubKey = keyFactory.generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
                    sig.initVerify(pubKey);
                    sig.update(testdata.getBytes("UTF-8"));
                    result = sig.verify(signatureBytes);
                    break;
                }
                case "HS256": {
                    KeyCollection.Keys ki = keys.stream().filter(k -> "oct".equals(k.getType())).findFirst().orElse(null);
                    if (ki == null) {
                        throw new GeneralSecurityException("No suitable key to decrypt HS256");
                    }
                    String keyBase64 = ki.getSymmetricKey();
                    while ((4 - keyBase64.length() % 4) % 4 != 0) {
                        keyBase64 = keyBase64.concat("=");
                    }
                    keyBase64 = keyBase64.replace("-", "+");
                    keyBase64 = keyBase64.replace("_", "/");
                    byte[] keyBytes = decoder.decode(keyBase64);
                    Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
                    SecretKeySpec secret_key = new SecretKeySpec(keyBytes, "HmacSHA256");
                    sha256_HMAC.init(secret_key);
                    byte[] compsign = sha256_HMAC.doFinal(testdata.getBytes());
                    String newsignature = encoder.encodeToString(compsign);
                    newsignature = newsignature.split("=")[0];
                    newsignature = newsignature.replace('+', '-');
                    newsignature = newsignature.replace('/', '_');
                    result = new String(signature).equals(newsignature);
                    if (!result) {
                        LOG.error("Invalid signature " + newsignature + " / " + data.substring(part2 + 1));
                    }
                }
                default: {
                    LOG.error("Unknown algorithm {} while decrypting the token", (Object)algorithm);
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | GeneralSecurityException e) {
            LOG.error("Error while decrypting the token", (Throwable)e);
            result = false;
        }
        try {
            parsedPayload = (Map)new ObjectMapper().readValue(payload, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            LOG.error("Unable to parse the JWT payload", (Throwable)e);
            parsedPayload = Collections.emptyMap();
            result = false;
        }
        this.payload = parsedPayload;
        this.isValid = result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Object claim(String key) {
        return this.payload.get(key);
    }

    public String getToken() {
        return this.token;
    }

    public String token() {
        return this.token;
    }

    public boolean expired() {
        return this.willHaveExpiredAt(Instant.now());
    }

    private boolean willHaveExpiredAt(Instant instant) {
        long notBefore;
        Object exp = this.payload.get("exp");
        if (exp != null) {
            long expiration = Long.parseLong(String.valueOf(exp));
            if (instant.isAfter(Instant.ofEpochSecond(expiration))) {
                return true;
            }
        } else {
            return true;
        }
        Object nbf = this.payload.get("nbf");
        return nbf != null && instant.isBefore(Instant.ofEpochSecond(notBefore = Long.parseLong(String.valueOf(nbf))));
    }

    public boolean willHaveExpiredIn(long time) {
        return this.willHaveExpiredAt(Instant.now().plusSeconds(time));
    }

    public int remainingValidity() {
        long notBefore;
        Object nbf;
        long expiration;
        Instant now = Instant.now();
        Object exp = this.payload.get("exp");
        long result = exp != null ? (now.isAfter(Instant.ofEpochSecond(expiration = Long.parseLong(String.valueOf(exp)))) ? -1L : expiration - now.getEpochSecond()) : Integer.MAX_VALUE;
        if (result >= 0L && (nbf = this.payload.get("nbf")) != null && now.isBefore(Instant.ofEpochSecond(notBefore = Long.parseLong(String.valueOf(nbf))))) {
            result = -1L;
        }
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        return (int)result;
    }
}

