/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo.internal.shell;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.commands.gogo.internal.shell.ShellRecipient;
import org.eclipse.sensinact.gateway.commands.gogo.osgi.CommandServiceMediator;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequestWrapper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellAccessRequest
implements NorthboundRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ShellAccessRequest.class);
    private NorthboundMediator mediator;
    private JSONObject request;
    private Authentication<?> authentication;
    private String content;

    public ShellAccessRequest(NorthboundMediator mediator, JSONObject request) {
        this.request = request;
        this.mediator = mediator;
    }

    public NorthboundMediator getMediator() {
        return this.mediator;
    }

    public String getRequestURI() {
        String uri = this.request.optString("uri");
        String[] uriElements = uri.split("\\?");
        return uriElements[0];
    }

    public Map<NorthboundRequestWrapper.QueryKey, List<String>> getQueryMap() {
        String uri = this.request.optString("uri");
        String[] uriElements = uri.split("\\?");
        if (uriElements.length == 2) {
            try {
                return NorthboundRequest.processRequestQuery((String)uriElements[1]);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public String getContent() {
        if (this.content == null) {
            JSONArray parameters = this.request.optJSONArray("parameters");
            if (parameters == null) {
                parameters = new JSONArray();
            }
            this.content = parameters.toString();
        }
        return this.content;
    }

    public Authentication<?> getAuthentication() {
        if (this.authentication == null) {
            String tokenHeader = (String)this.request.opt("token");
            String login = (String)this.request.opt("login");
            String password = (String)this.request.opt("password");
            if (tokenHeader != null) {
                this.authentication = new SessionToken(tokenHeader);
            } else if (login != null && password != null) {
                this.authentication = new Credentials(login, password);
            }
        }
        return this.authentication;
    }

    public String getRequestIdProperty() {
        return null;
    }

    public String getRequestId() {
        return null;
    }

    public NorthboundRecipient createRecipient(List<Parameter> parameters) {
        ShellRecipient recipient = new ShellRecipient((CommandServiceMediator)this.mediator);
        return recipient;
    }
}

