/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.util.location.Point;
import org.eclipse.sensinact.gateway.util.location.Segment;

public class LocationUtils {
    private static final double asin(double x) {
        return Math.asin(Math.max(-1.0, Math.min(x, 1.0)));
    }

    private static final double acos(double x) {
        return Math.acos(Math.max(-1.0, Math.min(x, 1.0)));
    }

    private static final double mod(double x, double y) {
        double m = x;
        if (Math.abs(m) > y) {
            m -= Math.floor(m / y) * y;
        }
        return m;
    }

    public static double getDistance(double lat1, double lng1, double lat2, double lng2) {
        double a = 6372797.6;
        double dlong = (lng2 - lng1) * (Math.PI / 180) / 2.0;
        double dlat = (lat2 - lat1) * (Math.PI / 180) / 2.0;
        double lat1_rad = lat1 * (Math.PI / 180);
        double lat2_rad = lat2 * (Math.PI / 180);
        double c = Math.pow(Math.sin(dlat), 2.0) + Math.pow(Math.sin(dlong), 2.0) * Math.cos(lat1_rad) * Math.cos(lat2_rad);
        double d = 2.0 * Math.atan2(Math.sqrt(c), Math.sqrt(1.0 - c));
        return a * d;
    }

    public static Segment getSphericalEarthModelCoordinates(double lat, double lng, int bearing, double distance) {
        double brg = (double)bearing * (Math.PI / 180);
        double lat1 = lat * (Math.PI / 180);
        double lng1 = lng * (Math.PI / 180);
        double a = 6372797.6;
        double s1 = distance / a;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(s1) + Math.cos(lat1) * Math.sin(s1) * Math.cos(brg));
        double lng2 = lng1 + Math.atan2(Math.sin(brg) * Math.sin(s1) * Math.cos(lat1), Math.cos(s1) - Math.sin(lat1) * Math.sin(lat2));
        double dLon = lng1 - lng2;
        double y = Math.sin(dLon) * Math.cos(lat1);
        double x = Math.cos(lat2) * Math.sin(lat1) - Math.sin(lat2) * Math.cos(lat1) * Math.cos(dLon);
        double d = Math.atan2(y, x);
        double finalBrg = d + Math.PI;
        double backBrg = d + Math.PI * 2;
        return new Segment(lat, lng, lat2 *= 57.29577951308232, lng2 *= 57.29577951308232, finalBrg *= 57.29577951308232, backBrg *= 57.29577951308232, distance);
    }

    public static double fromReverseClockedRadiusAngleToNorthOrientedBearing(double angle) {
        return LocationUtils.fromReverseClockedDegreesAngleToNorthOrientedBearing(57.29577951308232 * angle);
    }

    public static double fromReverseClockedDegreesAngleToNorthOrientedBearing(double angle) {
        double bearing = angle;
        bearing = angle < 90.0 ? 90.0 - angle : (angle < 180.0 ? 270.0 + (180.0 - angle) : (angle < 270.0 ? 180.0 + (270.0 - angle) : 90.0 + (360.0 - angle)));
        return Math.PI / 180 * bearing;
    }

    public static Point getDiffLatLng(Point origin, double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return origin;
        }
        double agl = 0.0;
        if (dy == 0.0) {
            agl = dx >= 0.0 ? 0.0 : 180.0;
        } else if (dx == 0.0) {
            agl = dy >= 0.0 ? 90.0 : 270.0;
        } else {
            agl = 57.29577951308232 * Math.atan(dy / dx);
            agl += (double)(dy < 0.0 && dx < 0.0 ? 180 : 0);
        }
        double distance = Math.sqrt(Math.pow(Math.abs(dx), 2.0) + Math.pow(Math.abs(dy), 2.0));
        Segment segment = LocationUtils.getElipsoidEarthModelCoordinates(origin.latitude, origin.longitude, LocationUtils.fromReverseClockedDegreesAngleToNorthOrientedBearing(agl), distance);
        return new Point(segment.getLat2(), segment.getLng2());
    }

    public static Segment getElipsoidEarthModelDistance(double latdep, double lngdep, double latarr, double lngarr) {
        double coslambda;
        double sinlambda;
        double lambdaB;
        double cossigma;
        double cos2sigmaM;
        double sinsigma;
        double sigma;
        double sinalpha;
        double cosSqalpha;
        double C;
        double a = 6378137.0;
        double f = 0.0033528106647474805;
        double b = a * (1.0 - f);
        double lat1 = latdep * (Math.PI / 180);
        double lng1 = lngdep * (Math.PI / 180);
        double lat2 = latarr * (Math.PI / 180);
        double lng2 = lngarr * (Math.PI / 180);
        double L = lng2 - lng1;
        double tanU1 = (1.0 - f) * Math.tan(lat1);
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double tanU2 = (1.0 - f) * Math.tan(lat2);
        double cosU2 = 1.0 / Math.sqrt(1.0 + tanU2 * tanU2);
        double sinU2 = tanU2 * cosU2;
        double lambda = L;
        int iterationLimit = 100;
        do {
            double sinSqsigma;
            if ((sinsigma = Math.sqrt(sinSqsigma = cosU2 * (sinlambda = Math.sin(lambda)) * (cosU2 * sinlambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (coslambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * coslambda))) == 0.0) {
                return new Segment(latdep, lngdep, latarr, lngarr, 0.0, 0.0, 0.0);
            }
            cossigma = sinU1 * sinU2 + cosU1 * cosU2 * coslambda;
            sigma = Math.atan2(sinsigma, cossigma);
            sinalpha = cosU1 * cosU2 * sinlambda / sinsigma;
            cosSqalpha = 1.0 - sinalpha * sinalpha;
            cos2sigmaM = cossigma - 2.0 * sinU1 * sinU2 / cosSqalpha;
            if (!Double.isNaN(cos2sigmaM)) continue;
            cos2sigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqalpha * (4.0 + f * (4.0 - 3.0 * cosSqalpha)))) * f * sinalpha * (sigma + C * sinsigma * (cos2sigmaM + C * cossigma * (-1.0 + 2.0 * cos2sigmaM * cos2sigmaM)))) - (lambdaB = lambda)) > 1.0E-12 && --iterationLimit > 0);
        if (iterationLimit == 0) {
            System.out.println("Formula failed to converge");
            return null;
        }
        double uSq = cosSqalpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltasigma = B * sinsigma * (cos2sigmaM + B / 4.0 * (cossigma * (-1.0 + 2.0 * cos2sigmaM * cos2sigmaM) - B / 6.0 * cos2sigmaM * (-3.0 + 4.0 * sinsigma * sinsigma) * (-3.0 + 4.0 * cos2sigmaM * cos2sigmaM)));
        double s = b * A * (sigma - deltasigma);
        double fwdAz = Math.atan2(cosU2 * sinlambda, cosU1 * sinU2 - sinU1 * cosU2 * coslambda);
        double revAz = Math.atan2(cosU1 * sinlambda, -sinU1 * cosU2 + cosU1 * sinU2 * coslambda);
        return new Segment(latdep, lngdep, latarr, lngarr, fwdAz *= 57.29577951308232, revAz *= 57.29577951308232, s);
    }

    public static Segment getElipsoidEarthModelCoordinates(double lat, double lng, double bearing, double distance) {
        double brg = bearing * (Math.PI / 180);
        double lat1 = lat * (Math.PI / 180);
        double lng1 = lng * (Math.PI / 180);
        double a = 6378137.0;
        double f = 0.0033528106647474805;
        double b = a * (1.0 - f);
        double sb = Math.sin(brg);
        double cb = Math.cos(brg);
        double tu1 = (1.0 - f) * Math.tan(lat1);
        double cu1 = 1.0 / Math.sqrt(1.0 + tu1 * tu1);
        double su1 = tu1 * cu1;
        double s2 = Math.atan2(tu1, cb);
        double sa = cu1 * sb;
        double csa = 1.0 - sa * sa;
        double us = csa * (a * a - b * b) / (b * b);
        double A = 1.0 + us / 16384.0 * (4096.0 + us * (-768.0 + us * (320.0 - 175.0 * us)));
        double B = us / 1024.0 * (256.0 + us * (-128.0 + us * (74.0 - 47.0 * us)));
        double s1 = distance / (b * A);
        double s1p = Math.PI * 2;
        double cs1m = 0.0;
        double ss1 = 0.0;
        double cs1 = 0.0;
        double ds1 = 0.0;
        while (Math.abs(s1 - s1p) > 1.0E-12) {
            cs1m = Math.cos(2.0 * s2 + s1);
            ss1 = Math.sin(s1);
            cs1 = Math.cos(s1);
            ds1 = B * ss1 * (cs1m + B / 4.0 * (cs1 * (-1.0 + 2.0 * cs1m * cs1m) - B / 6.0 * cs1m * (-3.0 + 4.0 * ss1 * ss1) * (-3.0 + 4.0 * cs1m * cs1m)));
            s1p = s1;
            s1 = distance / (b * A) + ds1;
        }
        double t = su1 * ss1 - cu1 * cs1 * cb;
        double lat2 = Math.atan2(su1 * cs1 + cu1 * ss1 * cb, (1.0 - f) * Math.sqrt(sa * sa + t * t));
        double l2 = Math.atan2(ss1 * sb, cu1 * cs1 - su1 * ss1 * cb);
        double c = f / 16.0 * csa * (4.0 + f * (4.0 - 3.0 * csa));
        double l = l2 - (1.0 - c) * f * sa * (s1 + c * ss1 * (cs1m + c * cs1 * (-1.0 + 2.0 * cs1m * cs1m)));
        double d = Math.atan2(sa, -t);
        double finalBrg = d + Math.PI * 2;
        double backBrg = d + Math.PI;
        double lng2 = lng1 + l;
        return new Segment(lat, lng, lat2 *= 57.29577951308232, lng2 *= 57.29577951308232, finalBrg *= 57.29577951308232, backBrg *= 57.29577951308232, distance);
    }

    public static final Segment getSegmentIntersection(Segment segment1, Segment segment2) {
        Segment crossSegment = LocationUtils.getElipsoidEarthModelDistance(segment1.getLat1(), segment1.getLng1(), segment2.getLat1(), segment2.getLng1());
        double a = 6378137.0;
        double crs12 = crossSegment.getRadForwardAzimuth();
        double crs21 = crossSegment.getRadForwardAzimuth() < Math.PI ? crossSegment.getRadForwardAzimuth() + Math.PI : (crossSegment.getRadForwardAzimuth() > Math.PI ? crossSegment.getRadForwardAzimuth() - Math.PI : 0.0);
        double crs13 = segment1.getRadForwardAzimuth();
        double crs23 = segment2.getRadForwardAzimuth();
        double ang1 = LocationUtils.mod(crs13 - crs12 + Math.PI, Math.PI * 2);
        double ang2 = LocationUtils.mod(crs21 - crs23 + Math.PI, Math.PI * 2);
        if (Math.sin(ang1 -= Math.PI) == 0.0 && Math.sin(ang2 -= Math.PI) == 0.0) {
            System.out.println("infinity of intersections");
            return null;
        }
        if (Math.sin(ang1) * Math.sin(ang2) < 0.0) {
            System.out.println("intersection ambiguous");
            return null;
        }
        ang1 = Math.abs(ang1);
        ang2 = Math.abs(ang2);
        double ang3 = LocationUtils.acos(-1.0 * Math.cos(ang1) * Math.cos(ang2) + Math.sin(ang1) * Math.sin(ang2) * Math.cos(crossSegment.getDistance() / a));
        double dst13 = a * Math.atan2(Math.sin(crossSegment.getDistance() / a) * Math.sin(ang1) * Math.sin(ang2), Math.cos(ang2) + Math.cos(ang1) * Math.cos(ang3));
        Segment intersection = LocationUtils.getElipsoidEarthModelCoordinates(segment1.getLat1(), segment1.getLng1(), segment1.getForwardAzimuth(), dst13);
        return intersection;
    }

    public static String toEPAF(double coordinate) {
        return LocationUtils.toEPAF((int)(coordinate * 100000.0));
    }

    private static String toEPAF(int coordinate) {
        int formated = coordinate;
        formated <<= 1;
        if (coordinate < 0) {
            formated ^= 0xFFFFFFFF;
        }
        StringBuilder builder = new StringBuilder();
        do {
            int car = 0;
            car = formated & 0x1F;
            if ((formated >>= 5) > 0) {
                car |= 0x20;
            }
            builder.append(Character.toChars(car += 63));
        } while (formated > 0);
        return builder.toString();
    }

    public static String toEPAF(Point[] points) {
        int lastLat = 0;
        int lastLng = 0;
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < points.length; ++index) {
            int lat = (int)(points[index].latitude * 100000.0);
            int lng = (int)(points[index].longitude * 100000.0);
            builder.append(LocationUtils.toEPAF(lat - lastLat));
            builder.append(LocationUtils.toEPAF(lng - lastLng));
            lastLat = lat;
            lastLng = lng;
        }
        return builder.toString();
    }

    public static List<Double> fromEPAF(String encoded) {
        int last = 0;
        char[] cars = encoded.toCharArray();
        ArrayList<Double> coordinates = new ArrayList<Double>();
        for (int pos = 0; pos < cars.length; ++pos) {
            int n = pos;
            cars[n] = (char)(cars[n] - 63);
            if ((cars[pos] & 0x20) == 32) continue;
            int coordinate = 0;
            int i = pos;
            do {
                coordinate |= (cars[i] & 0x1F) << (i - last) * 5;
            } while (--i >= last);
            if ((coordinate & 1) == 1) {
                coordinate ^= 0xFFFFFFFF;
            }
            double val = (double)(coordinate >>= 1) / 100000.0;
            if (coordinates.size() >= 2) {
                val = (Double)coordinates.get(coordinates.size() - 2) + val;
            }
            coordinates.add(val);
            last = pos + 1;
        }
        return coordinates;
    }

    public static List<Point> epafToPoints(String encoded) {
        ArrayList<Point> points = new ArrayList<Point>();
        List<Double> coordinates = LocationUtils.fromEPAF(encoded);
        if (coordinates.size() % 2 != 0) {
            return points;
        }
        for (int index = 0; index < coordinates.size(); index += 2) {
            points.add(new Point(coordinates.get(index), coordinates.get(index + 1)));
        }
        return points;
    }
}

