/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.tree;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNode;
import org.eclipse.sensinact.gateway.util.tree.PathNodeList;

public class PathNode<P extends PathNode<P>>
implements Iterable<P> {
    public static final String ANY_REGEX = "[^/]+";
    public static final String ANY_REPLACEMENT = "#ANY#";
    protected P parent;
    protected final String nodeName;
    protected final PathNodeList<P> children;
    protected final Pattern pattern;
    protected final boolean isRoot;
    protected final boolean isPattern;

    public PathNode() {
        this("/");
    }

    public PathNode(String nodeName) {
        this(nodeName, false);
    }

    public PathNode(String nodeName, boolean isPattern) {
        this.nodeName = nodeName;
        this.children = new PathNodeList();
        this.isRoot = nodeName.intern() == "/";
        this.isPattern = isPattern;
        this.pattern = isPattern ? Pattern.compile(nodeName) : null;
    }

    public P get(String path) {
        return this.get(UriUtils.getUriElements(path.replace(ANY_REGEX, ANY_REPLACEMENT)), 0);
    }

    public P get(String[] path, int index) {
        PathNode<P> node = null;
        if (this.isRoot && index != 0 || !this.isRoot && (path.length - index < 1 || !this.equals(path[index]))) {
            return (P)node;
        }
        int inc = this.isRoot ? 0 : 1;
        node = this;
        PathNode child = null;
        if (path.length - index > inc) {
            int incrementedIndex = index + inc;
            child = (PathNode)this.children.getStrictNode(path[incrementedIndex]);
            if (child != null) {
                node = child.get(path, incrementedIndex);
            } else {
                List<P> cs = this.children.getPatternNodes(path[incrementedIndex]);
                switch (cs.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        child = (PathNode)cs.get(0);
                        break;
                    }
                    default: {
                        int len = 0;
                        Object deeper = null;
                        for (int i = 0; i < cs.size(); ++i) {
                            P n = ((PathNode)cs.get(i)).get(path, incrementedIndex);
                            int clen = UriUtils.getUriElements(((PathNode)n).getPath()).length;
                            if (clen == path.length) {
                                deeper = n;
                                break;
                            }
                            if (clen <= len) continue;
                            deeper = n;
                            len = clen;
                        }
                        child = deeper;
                    }
                }
                if (child != null) {
                    node = child;
                }
            }
        }
        return (P)node;
    }

    public P add(P node) {
        if (node == null) {
            return null;
        }
        P child = this.children.getStrictNode(((PathNode)node).nodeName);
        if (child != null) {
            return child;
        }
        ((PathNode)node).parent = this;
        return this.children.add(node);
    }

    public P remove(String nodeName) {
        return this.children.remove(nodeName);
    }

    public int hashCode() {
        return this.nodeName.hashCode();
    }

    public String getName() {
        return this.nodeName;
    }

    public String getPath() {
        if (this.parent == null) {
            return "";
        }
        return UriUtils.getUri(new String[]{((PathNode)this.parent).getPath(), this.nodeName});
    }

    public boolean equals(Object object) {
        String objectName = null;
        if (PathNode.class.isAssignableFrom(object.getClass())) {
            objectName = ((PathNode)object).nodeName;
        } else if (String.class == object.getClass()) {
            objectName = (String)object;
        }
        if (objectName == null) {
            return false;
        }
        return ANY_REPLACEMENT.equals(objectName) || this.nodeName.equals(objectName) ? true : (this.isPattern ? this.pattern.matcher(objectName).matches() : false);
    }

    public int size() {
        return this.children.size();
    }

    public <N extends ImmutablePathNode<N>> N immutable(Class<N> ic, N parent) {
        try {
            return (N)((ImmutablePathNode)ic.getConstructor(ic, String.class, Boolean.TYPE, PathNodeList.class).newInstance(parent, this.nodeName, this.isPattern, this.children));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.nodeName);
        builder.append("[");
        for (PathNode node : this.children) {
            builder.append(node.toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Iterator<P> iterator() {
        return this.children.iterator();
    }
}

