/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONMapper {
    static final Pattern PATH_PATTERN = Pattern.compile("\\/?([^\\/]+)");
    static final Pattern PATH_ELEMENT_PATTERN = Pattern.compile("([^\\[\\]]+)?(?:\\[([^\\[\\]]+)(?:\\]))?");
    static final Pattern PATH_CONDITION_PATTERN = Pattern.compile("([^\\(\\)]+)|((\\()\\1(\\)))");
    static final Pattern PATH_EXPRESSION_PATTERN = Pattern.compile("(((&|\\|)?([^&\\|]+))?)");
    static final Pattern PATH_CONSTRAINT_PATTERN = Pattern.compile("([^=<>!]+)((=|<|>|(!=))([^=<>!]+))");
    private Map<String, JSONPath> mapping = new HashMap<String, JSONPath>();
    private Map<String, Object> patterns = new HashMap<String, Object>();

    private JSONMapper() {
        this(Thread.currentThread().getContextClassLoader());
    }

    private JSONMapper(ClassLoader classloader) {
    }

    public JSONMapper(JSONObject mapping) {
        this();
        int length;
        int n = length = mapping == null ? 0 : mapping.length();
        if (length > 0) {
            String[] names = JSONObject.getNames(mapping);
            for (int index = 0; index < length; ++index) {
                this.mapping.put(names[index], new JSONPath(mapping.getString(names[index])));
            }
        }
    }

    public JSONMapper(Map<String, String> mapping) {
        this();
        int length;
        int n = length = mapping == null ? 0 : mapping.size();
        if (length > 0) {
            String key = null;
            Iterator<String> iterator = mapping.keySet().iterator();
            while (iterator.hasNext()) {
                this.mapping.put(key, new JSONPath(mapping.get(key)));
                key = iterator.next();
            }
        }
    }

    public JSONObject parse(Object json) {
        String pattern2 = null;
        JSONObject result = new JSONObject();
        for (String key : this.mapping.keySet()) {
            for (String pattern2 : this.patterns.keySet()) {
                Object current = null;
                if (pattern2 != null) {
                    Object subject = this.patterns.get(pattern2);
                    subject = subject == null ? json : subject;
                    current = this.mapping.get(key).extract(subject);
                    this.patterns.put(pattern2, current);
                } else {
                    current = this.mapping.get(key).extract(json);
                }
                result.put(key, current);
            }
        }
        return result;
    }

    final class JSONPathElement {
        String element;
        JSONPathCondition condition;

        JSONPathElement(String pathElement) {
            Matcher matcher = null;
            matcher = PATH_ELEMENT_PATTERN.matcher(pathElement);
            if (!matcher.matches()) {
                return;
            }
            this.element = matcher.group(1);
            String condition = null;
            condition = matcher.group(2);
            if (condition != null) {
                this.condition = new JSONPathCondition(condition);
            }
        }

        private Object extract(Object json) {
            if (json == null) {
                return null;
            }
            if (JSONArray.class.isAssignableFrom(json.getClass())) {
                JSONArray operand = (JSONArray)json;
                if (this.element != null) {
                    JSONArray resultArray = new JSONArray();
                    int length = operand.length();
                    for (int index = 0; index < length; ++index) {
                        Object result = this.extract(operand.get(index));
                        if (result == null) continue;
                        resultArray.put(result);
                    }
                    return resultArray;
                }
                if (this.condition != null) {
                    return this.condition.apply(json);
                }
            } else if (JSONObject.class.isAssignableFrom(json.getClass())) {
                if (this.element != null) {
                    Object object = ((JSONObject)json).opt(this.element);
                    if (this.condition != null) {
                        return this.condition.apply(object);
                    }
                    return object;
                }
                if (this.condition != null) {
                    this.condition.apply(json);
                }
            }
            return null;
        }

        private class JSONPathCondition {
            String key = null;
            String value = null;

            JSONPathCondition(String condition) {
                char[] conditionChars = condition == null ? new char[]{} : condition.toCharArray();
                int index = 0;
                int length = conditionChars.length;
                char[] chars = new char[length += length > 0 ? 1 : 0];
                if (length > 0) {
                    System.arraycopy(conditionChars, 0, chars, 0, conditionChars.length);
                    chars[length - 1] = '\u0000';
                }
                StringBuilder sb = new StringBuilder();
                block5: while (index != chars.length) {
                    char c = chars[index++];
                    switch (c) {
                        case '=': {
                            this.key = sb.toString();
                            sb = new StringBuilder();
                            continue block5;
                        }
                        case ' ': {
                            continue block5;
                        }
                        case '\u0000': {
                            this.value = sb.toString();
                            continue block5;
                        }
                    }
                    sb.append(c);
                }
            }

            public Object apply(Object json) {
                if (JSONArray.class.isAssignableFrom(json.getClass())) {
                    JSONArray jsonArray = (JSONArray)json;
                    if (this.key == null) {
                        if (this.value == null) {
                            return json;
                        }
                        try {
                            return jsonArray.get(Integer.parseInt(this.value));
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            return null;
                        }
                    }
                    JSONArray resultArray = new JSONArray();
                    int length = jsonArray.length();
                    for (int index = 0; index < length; ++index) {
                        Object result = this.apply(jsonArray.get(index));
                        if (result == null) continue;
                        resultArray.put(result);
                    }
                    return resultArray;
                }
                if (JSONObject.class.isAssignableFrom(json.getClass())) {
                    JSONObject jsonObject = (JSONObject)json;
                    if (this.key == null) {
                        if (this.value == null || jsonObject.opt(this.value) != null) {
                            return json;
                        }
                        return null;
                    }
                    Object result = null;
                    try {
                        result = jsonObject.opt(this.key);
                        if (result != null && result.equals(CastUtils.cast(result.getClass(), this.value))) {
                            return json;
                        }
                    }
                    catch (ClassCastException e) {
                        return null;
                    }
                }
                return null;
            }
        }
    }

    final class JSONPath {
        List<JSONPathElement> pathElements = new LinkedList<JSONPathElement>();

        JSONPath(String path) {
            Matcher matcher = PATH_PATTERN.matcher(path);
            while (matcher.find()) {
                this.pathElements.add(new JSONPathElement(matcher.group()));
            }
        }

        private Object extract(Object json) {
            if (json == null || this.pathElements.size() == 0) {
                return null;
            }
            Object currentObject = json;
            Iterator<JSONPathElement> iterator = this.pathElements.iterator();
            while (iterator.hasNext()) {
                currentObject = iterator.next().extract(currentObject);
            }
            return currentObject;
        }
    }
}

