/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json.test;

import org.eclipse.sensinact.gateway.util.PropertyUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.log.LogService;

public class PropertyTest {
    private static final String MATCH = "match";
    private static final String PROPERTY = "this.is.$($(sub.sub.property).property).property";
    private static final String ALL_PROPERTY = "this.is.the.all.property";
    private static final String SUB_PROPERTY = "sub.property";
    private static final String SUB_SUB_PROPERTY = "sub.sub.property";
    private static final String LOG_FILTER = "(objectClass=" + LogService.class.getCanonicalName() + ")";
    private static final String MOCK_BUNDLE_NAME = "MockedBundle";
    private static final long MOCK_BUNDLE_ID = 1L;
    private final BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
    private final Bundle bundle = (Bundle)Mockito.mock(Bundle.class);

    @BeforeEach
    public void init() throws InvalidSyntaxException {
        Filter filter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)filter.toString()).thenReturn((Object)LOG_FILTER);
        Mockito.when((Object)this.context.createFilter(LOG_FILTER)).thenReturn((Object)filter);
        Mockito.when((Object)this.context.getServiceReferences((String)Mockito.eq(null), (String)Mockito.eq((Object)LOG_FILTER))).thenReturn(null);
        Mockito.when((Object)this.context.getServiceReference(LOG_FILTER)).thenReturn(null);
        Mockito.when((Object)this.context.getProperty(Mockito.anyString())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 1) {
                    return null;
                }
                if (((String)arguments[0]).intern() == PropertyTest.SUB_SUB_PROPERTY.intern()) {
                    return "sub";
                }
                if (((String)arguments[0]).intern() == PropertyTest.SUB_PROPERTY.intern()) {
                    return "the.all";
                }
                if (((String)arguments[0]).intern() == PropertyTest.ALL_PROPERTY.intern()) {
                    return PropertyTest.MATCH;
                }
                return null;
            }
        });
        Mockito.when((Object)this.context.getBundle()).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.bundle.getSymbolicName()).thenReturn((Object)MOCK_BUNDLE_NAME);
        Mockito.when((Object)this.bundle.getBundleId()).thenReturn((Object)1L);
    }

    @Test
    public void testProperty() throws Exception {
        String result = (String)PropertyUtils.getProperty((BundleContext)this.context, null, (String)PROPERTY);
        Assertions.assertEquals((Object)MATCH, (Object)result);
    }
}

