/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json;

import org.eclipse.sensinact.gateway.util.JSONUtils;
import org.json.JSONObject;
import org.json.JSONString;

public interface JSONStatement {
    public static final char VARIABLE_PREFIX = '$';
    public static final char OPEN_PARENTHESIS = '(';
    public static final char CLOSE_PARENTHESIS = ')';

    public boolean apply(String var1, Object var2);

    public void reset();

    public static final class JSONVariable
    implements JSONString {
        static final Object UNSET = new Object();
        private final String variable;
        private Object value = UNSET;

        public JSONVariable(String variable) {
            this.variable = variable;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void reset() {
            this.setValue(UNSET);
        }

        public String getName() {
            return this.variable;
        }

        @Override
        public String toJSONString() {
            return this.value == UNSET ? JSONObject.NULL.toString() : JSONUtils.toJSONFormat(this.value);
        }
    }
}

