/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNode;
import org.eclipse.sensinact.gateway.util.tree.ImmutablePathNodeBucket;

public class ImmutablePathNodeList<P extends ImmutablePathNode<P>>
implements Iterable<P> {
    private final Object lock = new Object();
    private final List<ImmutablePathNodeBucket<P>> buckets;

    protected ImmutablePathNodeList(List<ImmutablePathNodeBucket<P>> buckets) {
        this.buckets = Collections.unmodifiableList(buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P get(String nodeName) {
        if (nodeName == null || this.buckets.isEmpty()) {
            return null;
        }
        int hash = nodeName.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        Object object = this.lock;
        synchronized (object) {
            ImmutablePathNodeBucket<P> b = this.buckets.get((hash & this.buckets.size() - 2) + 1);
            while (b != null) {
                if (((ImmutablePathNode)b.node).nodeName.equals(nodeName)) {
                    return b.node;
                }
                b = b.next;
            }
            b = this.buckets.get(0);
            while (b != null) {
                if (((ImmutablePathNode)b.node).equals(nodeName)) {
                    return b.node;
                }
                b = b.next;
            }
        }
        return null;
    }

    public int size() {
        return this.buckets.size();
    }

    @Override
    public Iterator<P> iterator() {
        return new Iterator<P>(){
            int position = -1;
            ImmutablePathNodeBucket<P> bucket = null;
            P node = null;

            @Override
            public boolean hasNext() {
                if (this.position == -1) {
                    this.next();
                }
                return this.node != null;
            }

            @Override
            public P next() {
                Object current = this.node;
                if (this.bucket != null) {
                    this.bucket = this.bucket.next;
                }
                if (this.bucket == null) {
                    while (++this.position < ImmutablePathNodeList.this.buckets.size() && (this.bucket = (ImmutablePathNodeBucket)ImmutablePathNodeList.this.buckets.get(this.position)) == null) {
                    }
                }
                this.node = this.bucket == null ? null : this.bucket.node;
                return current;
            }

            @Override
            public void remove() {
            }
        };
    }
}

