/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.geojson;

import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.Geometry;
import org.eclipse.sensinact.gateway.geojson.LineString;
import org.eclipse.sensinact.gateway.geojson.MultiPoint;
import org.eclipse.sensinact.gateway.geojson.Polygon;
import org.eclipse.sensinact.gateway.geojson.utils.GeoJsonUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeoJsonUtilsTest {
    @Test
    void testCoordinates() {
        double epsilon = 1.0E-7;
        Coordinates testedNoElevation = GeoJsonUtils.coords((double)2.3480934384505394, (double)48.853566537211556);
        Assertions.assertEquals((double)2.3480934, (double)testedNoElevation.longitude, (double)1.0E-7);
        Assertions.assertEquals((double)48.8535665, (double)testedNoElevation.latitude, (double)1.0E-7);
        Assertions.assertTrue((boolean)Double.isNaN(testedNoElevation.elevation));
        Coordinates testedWithElevation = GeoJsonUtils.coords((double)2.3480934384505394, (double)48.853566537211556, (double)36.0);
        Assertions.assertEquals((double)2.3480934, (double)testedWithElevation.longitude, (double)1.0E-7);
        Assertions.assertEquals((double)48.8535665, (double)testedWithElevation.latitude, (double)1.0E-7);
        Assertions.assertEquals((double)36.0, (double)testedWithElevation.elevation, (double)1.0E-7);
        Coordinates testedWithElevation2 = GeoJsonUtils.coords((double)2.3480934384505394, (double)48.853566537211556, (double)36.0);
        Assertions.assertTrue((testedWithElevation != testedWithElevation2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)testedWithElevation.hashCode(), (int)testedWithElevation2.hashCode());
        Assertions.assertEquals((Object)testedWithElevation, (Object)testedWithElevation2);
        Assertions.assertNotEquals((Object)testedWithElevation, (Object)testedNoElevation);
        Assertions.assertNotEquals((Object)testedNoElevation, (Object)testedWithElevation);
        Coordinates testedNoElevation2 = GeoJsonUtils.coords((double)2.3480934384505394, (double)48.853566537211556);
        Assertions.assertTrue((testedNoElevation != testedNoElevation2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)testedNoElevation.hashCode(), (int)testedNoElevation2.hashCode());
        Assertions.assertEquals((Object)testedNoElevation, (Object)testedNoElevation2);
        Assertions.assertEquals((Object)testedNoElevation, (Object)GeoJsonUtils.coords((double)2.3480934384505394, (double)48.853566537211556, (double)Double.NaN));
    }

    @Test
    void testPoint() {
        double lon = 2.295052;
        double lat = 48.873771;
        double elev = 59.0;
        Coordinates coords = GeoJsonUtils.coords((double)lon, (double)lat, (double)elev);
        Coordinates coordsNoElev = GeoJsonUtils.coords((double)lon, (double)lat);
        Assertions.assertEquals(Map.of(), (Object)GeoJsonUtils.point((Coordinates)coords).foreignMembers);
        Assertions.assertEquals((Object)coords, (Object)GeoJsonUtils.point((Coordinates)coords).coordinates);
        Assertions.assertEquals((Object)coords, (Object)GeoJsonUtils.point((double)lon, (double)lat, (double)elev).coordinates);
        Assertions.assertEquals((Object)coordsNoElev, (Object)GeoJsonUtils.point((double)lon, (double)lat).coordinates);
        Assertions.assertEquals((Object)coordsNoElev, (Object)GeoJsonUtils.point((double)lon, (double)lat, (double)Double.NaN).coordinates);
    }

    @Test
    void testLineString() {
        double lon1 = 2.27968;
        double lat1 = 48.85002;
        double elev1 = 29.0;
        Coordinates coords1 = GeoJsonUtils.coords((double)lon1, (double)lat1, (double)elev1);
        double lon2 = -74.0444947;
        double lat2 = 40.6892558;
        double elev2 = 5.0;
        Coordinates coords2 = GeoJsonUtils.coords((double)lon2, (double)lat2, (double)elev2);
        Assertions.assertNotEquals((Object)coords1, (Object)coords2);
        LineString line = GeoJsonUtils.lineString((Coordinates)coords1, (Coordinates)coords2, (Coordinates[])new Coordinates[0]);
        Assertions.assertEquals(Map.of(), (Object)line.foreignMembers);
        Assertions.assertEquals((int)2, (int)line.coordinates.size());
        Assertions.assertEquals((Object)coords1, line.coordinates.get(0));
        Assertions.assertEquals((Object)coords2, line.coordinates.get(1));
        LineString reverseLine = GeoJsonUtils.lineString((Coordinates)coords2, (Coordinates)coords1, (Coordinates[])new Coordinates[0]);
        Assertions.assertNotEquals((int)line.hashCode(), (int)reverseLine.hashCode());
        Assertions.assertNotEquals((Object)line, (Object)reverseLine);
        Assertions.assertNotEquals((Object)reverseLine, (Object)line);
        double lon3 = 7.299085;
        double lat3 = 43.727424;
        double elev3 = 369.86;
        Coordinates coords3 = GeoJsonUtils.coords((double)lon3, (double)lat3, (double)elev3);
        LineString threePoints = GeoJsonUtils.lineString((Coordinates)coords1, (Coordinates)coords2, (Coordinates[])new Coordinates[]{coords3});
        Assertions.assertEquals((int)3, (int)threePoints.coordinates.size());
        Assertions.assertEquals((Object)coords1, threePoints.coordinates.get(0));
        Assertions.assertEquals((Object)coords2, threePoints.coordinates.get(1));
        Assertions.assertEquals((Object)coords3, threePoints.coordinates.get(2));
        Assertions.assertNotEquals((Object)line, (Object)threePoints);
    }

    @Test
    void testMultiPoint() {
        double lon1 = 2.27968;
        double lat1 = 48.85002;
        double elev1 = 29.0;
        Coordinates coords1 = GeoJsonUtils.coords((double)lon1, (double)lat1, (double)elev1);
        double lon2 = -74.0444947;
        double lat2 = 40.6892558;
        double elev2 = 5.0;
        Coordinates coords2 = GeoJsonUtils.coords((double)lon2, (double)lat2, (double)elev2);
        MultiPoint points = GeoJsonUtils.multiPoint((Coordinates[])new Coordinates[]{coords1, coords2});
        Assertions.assertEquals(Map.of(), (Object)points.foreignMembers);
        Assertions.assertEquals((int)2, (int)points.coordinates.size());
        Assertions.assertEquals((Object)coords1, points.coordinates.get(0));
        Assertions.assertEquals((Object)coords2, points.coordinates.get(1));
        MultiPoint reversePoints = GeoJsonUtils.multiPoint((Coordinates[])new Coordinates[]{coords2, coords1});
        Assertions.assertNotEquals((int)points.hashCode(), (int)reversePoints.hashCode());
        Assertions.assertNotEquals((Object)points, (Object)reversePoints);
        Assertions.assertNotEquals((Object)reversePoints, (Object)points);
        double lon3 = 7.299085;
        double lat3 = 43.727424;
        double elev3 = 369.86;
        Coordinates coords3 = GeoJsonUtils.coords((double)lon3, (double)lat3, (double)elev3);
        MultiPoint threePoints = GeoJsonUtils.multiPoint((Coordinates[])new Coordinates[]{coords1, coords2, coords3});
        Assertions.assertEquals((int)3, (int)threePoints.coordinates.size());
        Assertions.assertEquals((Object)coords1, threePoints.coordinates.get(0));
        Assertions.assertEquals((Object)coords2, threePoints.coordinates.get(1));
        Assertions.assertEquals((Object)coords3, threePoints.coordinates.get(2));
        Assertions.assertNotEquals((Object)points, (Object)threePoints);
    }

    @Test
    void testPolygon() {
        double lon1 = 2.27968;
        double lat1 = 48.85002;
        double elev1 = 29.0;
        Coordinates coords1 = GeoJsonUtils.coords((double)lon1, (double)lat1, (double)elev1);
        double lon2 = -74.0444947;
        double lat2 = 40.6892558;
        double elev2 = 5.0;
        Coordinates coords2 = GeoJsonUtils.coords((double)lon2, (double)lat2, (double)elev2);
        double lon3 = 7.299085;
        double lat3 = 43.727424;
        double elev3 = 369.86;
        Coordinates coords3 = GeoJsonUtils.coords((double)lon3, (double)lat3, (double)elev3);
        double lon4 = 2.29449;
        double lat4 = 48.858255;
        double elev4 = 312.99;
        Coordinates coords4 = GeoJsonUtils.coords((double)lon4, (double)lat4, (double)elev4);
        Polygon polygon1Opened = GeoJsonUtils.polygon((Coordinates)coords1, (Coordinates)coords2, (Coordinates)coords3, (Coordinates[])new Coordinates[0]);
        Assertions.assertEquals(Map.of(), (Object)polygon1Opened.foreignMembers);
        Assertions.assertEquals((int)1, (int)polygon1Opened.coordinates.size());
        Assertions.assertEquals((int)4, (int)((List)polygon1Opened.coordinates.get(0)).size());
        Assertions.assertEquals((Object)coords1, ((List)polygon1Opened.coordinates.get(0)).get(0));
        Assertions.assertEquals((Object)coords2, ((List)polygon1Opened.coordinates.get(0)).get(1));
        Assertions.assertEquals((Object)coords3, ((List)polygon1Opened.coordinates.get(0)).get(2));
        Assertions.assertEquals((Object)coords1, ((List)polygon1Opened.coordinates.get(0)).get(3));
        Polygon polygon1Closed = GeoJsonUtils.polygon((Coordinates)coords1, (Coordinates)coords2, (Coordinates)coords3, (Coordinates[])new Coordinates[]{coords1});
        Assertions.assertEquals((int)1, (int)polygon1Closed.coordinates.size());
        Assertions.assertEquals((int)4, (int)((List)polygon1Closed.coordinates.get(0)).size());
        Assertions.assertEquals((Object)coords1, ((List)polygon1Closed.coordinates.get(0)).get(0));
        Assertions.assertEquals((Object)coords2, ((List)polygon1Closed.coordinates.get(0)).get(1));
        Assertions.assertEquals((Object)coords3, ((List)polygon1Closed.coordinates.get(0)).get(2));
        Assertions.assertEquals((Object)coords1, ((List)polygon1Closed.coordinates.get(0)).get(3));
        Assertions.assertEquals((Object)polygon1Closed, (Object)polygon1Opened);
        Polygon polygon2Opened = GeoJsonUtils.polygon((Coordinates)coords1, (Coordinates)coords2, (Coordinates)coords3, (Coordinates[])new Coordinates[]{coords4});
        Assertions.assertEquals((int)1, (int)polygon2Opened.coordinates.size());
        Assertions.assertEquals((int)5, (int)((List)polygon2Opened.coordinates.get(0)).size());
        Assertions.assertEquals((Object)coords1, ((List)polygon2Opened.coordinates.get(0)).get(0));
        Assertions.assertEquals((Object)coords2, ((List)polygon2Opened.coordinates.get(0)).get(1));
        Assertions.assertEquals((Object)coords3, ((List)polygon2Opened.coordinates.get(0)).get(2));
        Assertions.assertEquals((Object)coords4, ((List)polygon2Opened.coordinates.get(0)).get(3));
        Assertions.assertEquals((Object)coords1, ((List)polygon2Opened.coordinates.get(0)).get(4));
        Polygon polygon2Closed = GeoJsonUtils.polygon((Coordinates)coords1, (Coordinates)coords2, (Coordinates)coords3, (Coordinates[])new Coordinates[]{coords4, coords1});
        Assertions.assertEquals((int)1, (int)polygon2Closed.coordinates.size());
        Assertions.assertEquals((int)5, (int)((List)polygon2Closed.coordinates.get(0)).size());
        Assertions.assertEquals((Object)coords1, ((List)polygon2Closed.coordinates.get(0)).get(0));
        Assertions.assertEquals((Object)coords2, ((List)polygon2Closed.coordinates.get(0)).get(1));
        Assertions.assertEquals((Object)coords3, ((List)polygon2Closed.coordinates.get(0)).get(2));
        Assertions.assertEquals((Object)coords4, ((List)polygon2Closed.coordinates.get(0)).get(3));
        Assertions.assertEquals((Object)coords1, ((List)polygon2Closed.coordinates.get(0)).get(4));
        Assertions.assertEquals((Object)polygon2Closed, (Object)polygon2Opened);
    }

    @Test
    void testFeature() {
        double lat = 45.184957;
        double lon = 5.735451;
        Feature feature = GeoJsonUtils.feature((String)"someId", (Geometry)GeoJsonUtils.point((double)lat, (double)lon));
        Assertions.assertEquals((Object)"someId", (Object)feature.id);
        Assertions.assertNotNull((Object)feature.properties);
        Assertions.assertEquals(Map.of(), (Object)feature.foreignMembers);
        FeatureCollection collection = GeoJsonUtils.featureCollection((Feature[])new Feature[]{feature});
        Assertions.assertEquals((int)1, (int)collection.features.size());
        Assertions.assertEquals((Object)feature, collection.features.get(0));
        Assertions.assertEquals(Map.of(), (Object)collection.foreignMembers);
    }
}

