/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.session.SensiNactSession;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.rest.FeaturesOfInterestAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.SnapshotFilter;

public class FeaturesOfInterestAccessImpl
implements FeaturesOfInterestAccess {
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(null);
    }

    public FeatureOfInterest getFeatureOfInterest(String id) {
        FeatureOfInterest foi;
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            foi = DtoMapper.toFeatureOfInterest(this.getSession(), this.uriInfo, this.getMapper(), provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException("No feature of interest with id");
        }
        if (!foi.id.equals(id)) {
            throw new NotFoundException();
        }
        return foi;
    }

    public ResultList<Observation> getFeatureOfInterestObservations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        SensiNactSession userSession = this.getSession();
        ResultList list = new ResultList();
        list.value = userSession.filteredSnapshot((ICriterion)new SnapshotFilter(provider)).stream().flatMap(p -> p.getServices().stream()).flatMap(s -> s.getResources().stream()).filter(ResourceSnapshot::isSet).map(r -> DtoMapper.toObservation(this.uriInfo, r)).collect(Collectors.toList());
        return list;
    }

    public Observation getFeatureOfInterestObservation(String id, String id2) {
        Observation o;
        String provider2;
        String provider = DtoMapper.extractFirstIdSegment(id);
        if (!provider.equals(provider2 = DtoMapper.extractFirstIdSegment(id2))) {
            throw new BadRequestException("The ids for the FeatureOfInterest and the Observation are inconsistent");
        }
        String service = DtoMapper.extractFirstIdSegment(id2.substring(provider2.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + service.length() + 2));
        try {
            o = DtoMapper.toObservation(this.uriInfo, this.getSession().describeResource(provider2, service, resource));
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
        if (!id2.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Datastream getFeatureOfInterestObservationDatastream(String id, String id2) {
        Datastream d;
        String provider2;
        String provider = DtoMapper.extractFirstIdSegment(id);
        if (!provider.equals(provider2 = DtoMapper.extractFirstIdSegment(id2))) {
            throw new BadRequestException("The ids for the FeatureOfInterest and the Observation are inconsistent");
        }
        String service = DtoMapper.extractFirstIdSegment(id2.substring(provider2.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + service.length() + 2));
        SensiNactSession userSession = this.getSession();
        try {
            d = DtoMapper.toDatastream(userSession, this.getMapper(), this.uriInfo, userSession.describeResource(provider2, service, resource));
        }
        catch (Exception e) {
            throw new NotFoundException();
        }
        if (!String.join((CharSequence)"~", provider, service, resource).equals(d.id)) {
            throw new NotFoundException();
        }
        return d;
    }
}

