/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.HistoricalLocationsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;

public class HistoricalLocationsAccessImpl
implements HistoricalLocationsAccess {
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(null);
    }

    public HistoricalLocation getHistoricalLocation(String id) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.getMapper(), this.uriInfo, provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException("No feature of interest with id");
        }
        if (!hl.id.equals(id)) {
            throw new NotFoundException();
        }
        return hl;
    }

    public ResultList<Location> getHistoricalLocationLocations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toLocation(this.getSession(), this.uriInfo, this.getMapper(), provider));
        return list;
    }

    public Location getHistoricalLocationLocation(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        Location loc = DtoMapper.toLocation(this.getSession(), this.uriInfo, this.getMapper(), provider);
        if (!id2.equals(loc.id)) {
            throw new NotFoundException();
        }
        return loc;
    }

    public ResultList<Thing> getHistoricalLocationLocationThings(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toThing(this.getSession(), this.uriInfo, provider));
        return list;
    }

    public ResultList<HistoricalLocation> getHistoricalLocationLocationHistoricalLocations(String id, String id2) {
        ResultList list = new ResultList();
        list.value = List.of(this.getHistoricalLocation(id));
        return list;
    }

    public Thing getHistoricalLocationThing(String id) {
        Thing t;
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        try {
            t = DtoMapper.toThing(this.getSession(), this.uriInfo, provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException("No feature of interest with id");
        }
        if (!t.id.equals(provider)) {
            throw new NotFoundException();
        }
        return t;
    }

    public ResultList<Datastream> getHistoricalLocationThingDatastreams(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        SensiNactSession userSession = this.getSession();
        ResultList list = new ResultList();
        list.value = userSession.describeProvider((String)provider).services.stream().map(s -> userSession.describeService(provider, s)).flatMap(s -> s.resources.stream().map(r -> userSession.describeResource(s.provider, s.service, r))).map(r -> DtoMapper.toDatastream(userSession, this.getMapper(), this.uriInfo, r)).collect(Collectors.toList());
        return list;
    }

    public ResultList<HistoricalLocation> getHistoricalLocationThingHistoricalLocations(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getHistoricalLocation(id));
        return list;
    }

    public ResultList<Location> getHistoricalLocationThingLocations(String id) {
        return this.getHistoricalLocationLocations(id);
    }
}

