/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.util.List;
import org.eclipse.sensinact.core.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.SensorsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;

public class SensorsAccessImpl
implements SensorsAccess {
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;
    @Context
    Application application;

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(null);
    }

    public Sensor getSensor(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return DtoMapper.toSensor(this.uriInfo, this.getSession().describeResource(provider, service, resource));
    }

    public ResultList<Datastream> getSensorDatastreams(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getSensorDatastream(id, id));
        return list;
    }

    public Datastream getSensorDatastream(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return DtoMapper.toDatastream(userSession, this.getMapper(), this.uriInfo, userSession.describeResource(provider, service, resource));
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getSensorDatastreamObservations(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return RootResourceAccessImpl.getObservationList(this.getSession(), this.uriInfo, this.application, provider, service, resource);
    }

    public ObservedProperty getSensorDatastreamObservedProperty(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        ObservedProperty o = DtoMapper.toObservedProperty(this.uriInfo, this.getSession().describeResource(provider, service, resource));
        if (!id.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Sensor getSensorDatastreamSensor(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        return this.getSensor(id);
    }

    public Thing getSensorDatastreamThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        Thing t = DtoMapper.toThing(this.getSession(), this.uriInfo, provider);
        if (!provider.equals(t.id)) {
            throw new NotFoundException();
        }
        return t;
    }
}

