/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.dto;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;

public class SensinactPathDeserializer
extends StdDeserializer<SensinactPath> {
    private static final long serialVersionUID = 1L;

    public SensinactPathDeserializer() {
        this(null);
    }

    protected SensinactPathDeserializer(Class<?> vc) {
        super(vc);
    }

    public SensinactPath deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        if (node.isTextual()) {
            return SensinactPath.fromUri(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        if (!node.isObject()) {
            throw new IOException("Sensinact path should be an object or a string");
        }
        SensinactPath path = new SensinactPath();
        path.provider = this.getValue(node, "provider");
        path.service = this.getValue(node, "service");
        path.resource = this.getValue(node, "resource");
        path.metadata = this.getValue(node, "metadata");
        return path;
    }

    private String getValue(JsonNode node, String key) {
        if (node.has(key)) {
            return node.get(key).asText();
        }
        return null;
    }
}

