/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.extract.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.dto.impl.MetadataUpdateDto;
import org.eclipse.sensinact.core.extract.impl.DataExtractor;
import org.eclipse.sensinact.core.push.dto.GenericDto;

public class GenericDtoDataExtractor
implements DataExtractor {
    @Override
    public List<? extends AbstractUpdateDto> getUpdates(Object update) {
        AbstractUpdateDto dud;
        Instant instant;
        GenericDto dto = this.check(update);
        ArrayList<DataUpdateDto> list = new ArrayList<DataUpdateDto>();
        Instant instant2 = instant = dto.timestamp == null ? Instant.now() : dto.timestamp;
        if (dto.value != null || dto.nullAction == NullAction.UPDATE) {
            dud = new DataUpdateDto();
            instant = this.copyCommonFields(dto, instant, dud);
            if (dto.type != null) {
                dud.type = dto.type;
            }
            dud.data = dto.value;
            list.add((DataUpdateDto)dud);
        }
        if (dto.metadata != null) {
            dud = new MetadataUpdateDto();
            instant = this.copyCommonFields(dto, instant, dud);
            ((MetadataUpdateDto)dud).metadata = dto.metadata;
            ((MetadataUpdateDto)dud).removeNullValues = true;
            list.add((DataUpdateDto)dud);
        }
        return list;
    }

    private Instant copyCommonFields(GenericDto dto, Instant instant, AbstractUpdateDto dud) {
        dud.model = dto.model;
        dud.provider = dto.provider;
        dud.service = dto.service;
        dud.resource = dto.resource;
        dud.timestamp = instant;
        return instant;
    }

    private GenericDto check(Object update) {
        GenericDto dto;
        try {
            dto = (GenericDto)GenericDto.class.cast(update);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The supplied update dto is not of the correct type to extract", e);
        }
        if (dto.provider == null) {
            throw new IllegalArgumentException("No provider is defined");
        }
        if (dto.service == null) {
            throw new IllegalArgumentException("No service is defined");
        }
        if (dto.resource == null) {
            throw new IllegalArgumentException("No resource is defined");
        }
        return dto;
    }
}

