/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl;

import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class SetValueCommand
extends AbstractSensinactCommand<Void> {
    private final DataUpdateDto dataUpdateDto;

    public SetValueCommand(DataUpdateDto dataUpdateDto) {
        this.dataUpdateDto = dataUpdateDto;
    }

    protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
        String mod = this.dataUpdateDto.model == null ? this.dataUpdateDto.provider : this.dataUpdateDto.model;
        String provider = this.dataUpdateDto.provider;
        String svc = this.dataUpdateDto.service;
        String res = this.dataUpdateDto.resource;
        if (mod == null || provider == null || svc == null || res == null) {
            return promiseFactory.failed((Throwable)new NullPointerException("The provider, service and resource must be non null"));
        }
        SensinactResource resource = twin.getResource(mod, provider, svc, res);
        if (resource == null) {
            SensinactProvider sp;
            Resource r;
            Service service;
            Model model = modelMgr.getModel(mod);
            if (model == null) {
                model = modelMgr.createModel(mod).withCreationTime(this.dataUpdateDto.timestamp).build();
            }
            if ((service = (Service)model.getServices().get(svc)) == null) {
                service = (Service)model.createService(svc).withCreationTime(this.dataUpdateDto.timestamp).build();
            }
            if ((r = (Resource)service.getResources().get(res)) == null) {
                r = (Resource)service.createResource(res).withValueType(ValueType.UPDATABLE).withType(this.dataUpdateDto.type).build();
            }
            if ((sp = twin.getProvider(mod, provider)) == null) {
                sp = twin.createProvider(mod, provider, this.dataUpdateDto.timestamp);
            }
            resource = (SensinactResource)((SensinactService)sp.getServices().get(svc)).getResources().get(res);
        }
        return resource.setValue(this.dataUpdateDto.data, this.dataUpdateDto.timestamp);
    }
}

