/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.nexus;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sensinact.core.command.impl.ActionHandler;
import org.eclipse.sensinact.core.command.impl.ResourcePullHandler;
import org.eclipse.sensinact.core.command.impl.ResourcePushHandler;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.model.nexus.emf.compare.EMFCompareUtil;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.whiteboard.impl.SensinactWhiteboard;
import org.eclipse.sensinact.model.core.metadata.Action;
import org.eclipse.sensinact.model.core.metadata.ActionParameter;
import org.eclipse.sensinact.model.core.metadata.AnnotationMetadata;
import org.eclipse.sensinact.model.core.metadata.MetadataFactory;
import org.eclipse.sensinact.model.core.metadata.NexusMetadata;
import org.eclipse.sensinact.model.core.metadata.ResourceAttribute;
import org.eclipse.sensinact.model.core.metadata.ResourceMetadata;
import org.eclipse.sensinact.model.core.metadata.ServiceReference;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.provider.FeatureCustomMetadata;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderFactory;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelNexus {
    private static final Logger LOG = LoggerFactory.getLogger(ModelNexus.class);
    private static final String BASE = "data/";
    private static final String INSTANCES = "data/instances/";
    private static final String BASIC_BASE_ECORE = "data/models/basic/base.ecore";
    private static final String DEFAULT_URI = "https://eclipse.org/sensinact/base";
    private static final URI DEFAULT_URI_OBJECT = URI.createURI((String)"https://eclipse.org/sensinact/base");
    private final ResourceSet resourceSet;
    private final ProviderPackage providerPackage;
    private final Supplier<NotificationAccumulator> notificationAccumulator;
    private Map<URI, EPackage> packageCache = new ConcurrentHashMap<URI, EPackage>();
    private EPackage defaultPackage;
    private final Map<String, Provider> providers = new HashMap<String, Provider>();
    private final Map<String, EClass> models = new HashMap<String, EClass>();
    private final SensinactWhiteboard whiteboard;

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator) {
        this(resourceSet, ProviderPackage2, accumulator, (SensinactWhiteboard)null);
    }

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator, ActionHandler actionHandler) {
        this(resourceSet, ProviderPackage2, accumulator, actionHandler, null, null);
    }

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator, final ActionHandler actionHandler, final ResourcePullHandler resourceValuePullHandler, final ResourcePushHandler resourceValuePushHandler) {
        this(resourceSet, ProviderPackage2, accumulator, new SensinactWhiteboard(null, null){

            @Override
            public Promise<Object> act(String model, String provider, String service, String resource, Map<String, Object> arguments) {
                if (actionHandler != null) {
                    return actionHandler.act(model, provider, service, resource, arguments);
                }
                throw new RuntimeException("No action handler set");
            }

            @Override
            public <T> Promise<TimedValue<T>> pullValue(String model, String provider, String service, String resource, Class<T> type, TimedValue<T> cachedValue, Consumer<TimedValue<T>> gatewayUpdate) {
                if (resourceValuePullHandler != null) {
                    return resourceValuePullHandler.pullValue(model, provider, service, resource, type, cachedValue, gatewayUpdate);
                }
                throw new RuntimeException("No pullValue handler set");
            }

            @Override
            public <T> Promise<TimedValue<T>> pushValue(String model, String provider, String service, String resource, Class<T> type, TimedValue<T> cachedValue, TimedValue<T> newValue, Consumer<TimedValue<T>> gatewayUpdate) {
                if (resourceValuePushHandler != null) {
                    return resourceValuePushHandler.pushValue(model, provider, service, resource, type, cachedValue, newValue, gatewayUpdate);
                }
                throw new RuntimeException("No pushValue handler set");
            }
        });
    }

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator, SensinactWhiteboard whiteboard) {
        this.resourceSet = resourceSet;
        this.providerPackage = ProviderPackage2;
        this.notificationAccumulator = accumulator;
        this.whiteboard = whiteboard;
        Optional<EPackage> packageOptional = this.loadDefaultPackage(Paths.get(BASIC_BASE_ECORE, new String[0]));
        this.defaultPackage = packageOptional.orElseGet(() -> EMFUtil.createPackage("base", DEFAULT_URI, "sensinactBase", this.resourceSet));
        this.defaultPackage.setEFactoryInstance((EFactory)new EFactoryImpl(){

            protected EObject basicCreate(EClass eClass) {
                return eClass.getInstanceClassName() == "java.util.Map$Entry" ? new MinimalEObjectImpl.Container.Dynamic.BasicEMapEntry(eClass) : new MinimalEObjectImpl.Container.Dynamic.Permissive(eClass);
            }
        });
        this.packageCache.put(DEFAULT_URI_OBJECT, this.defaultPackage);
        this.loadInstances();
        this.setupSensinactProvider();
    }

    private Optional<EPackage> loadDefaultPackage(Path fileName) {
        Resource resource = this.resourceSet.createResource(URI.createFileURI((String)fileName.toString()));
        if (Files.isRegularFile(fileName, new LinkOption[0])) {
            try {
                resource.load(null);
                if (!resource.getContents().isEmpty()) {
                    EPackage defaultPackage = (EPackage)resource.getContents().get(0);
                    resource.setURI(URI.createURI((String)defaultPackage.getNsURI()));
                    this.resourceSet.getResources().remove((Object)resource);
                    this.resourceSet.getPackageRegistry().put((Object)defaultPackage.getNsURI(), (Object)defaultPackage);
                    return Optional.of(defaultPackage);
                }
            }
            catch (IOException e) {
                LOG.error("THIS WILL BE A RUNTIME EXCPETION FOR NOW: Error Loading default EPackage from persistent file: {}", (Object)fileName, (Object)e);
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    private void loadInstances() {
        Path instancesPath = Paths.get(INSTANCES, new String[0]);
        if (Files.isDirectory(instancesPath, new LinkOption[0])) {
            try {
                Files.walk(instancesPath, new FileVisitOption[0]).forEach(this::load);
            }
            catch (IOException e) {
                LOG.error("THIS WILL BE A RUNTIME EXCPETION FOR NOW: Error loading instances from Path: {}", (Object)instancesPath, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void load(Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            URI uri = URI.createFileURI((String)path.toString());
            Resource resource = this.resourceSet.createResource(uri);
            resource.load(null);
            if (!resource.getContents().isEmpty()) {
                Provider provider = (Provider)resource.getContents().get(0);
                EClass eClass = provider.eClass();
                this.models.putIfAbsent(EMFUtil.getModelName(eClass), eClass);
                this.providers.put(provider.getId(), provider);
            }
        }
        catch (IOException e) {
            LOG.error("THIS WILL BE A RUNTIME EXCPETION FOR NOW: Error loading provider from Path: {}", (Object)path, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void setupSensinactProvider() {
        Instant now = Instant.now();
        EClass sensiNactModel = this.getModel("sensinact").orElseGet(() -> this.createModel("sensinact", now));
        EReference svc = Optional.ofNullable(this.getServiceForModel(sensiNactModel, "system")).orElseGet(() -> this.createService(sensiNactModel, "system", now));
        EClass svcClass = svc.getEReferenceType();
        EStructuralFeature versionResource = Optional.ofNullable(svcClass.getEStructuralFeature("version")).orElseGet(() -> this.createResource(svcClass, "version", Double.TYPE, now, null));
        EStructuralFeature startedResource = Optional.ofNullable(svcClass.getEStructuralFeature("started")).orElseGet(() -> this.createResource(svcClass, "started", Instant.class, now, null));
        Provider provider = Optional.ofNullable(this.getProvider("sensiNact")).orElseGet(() -> this.doCreateProvider("sensinact", sensiNactModel, "sensiNact", now));
        this.handleDataUpdate("sensinact", provider, (EStructuralFeature)svc, versionResource, 0.1, now);
        this.handleDataUpdate("sensinact", provider, (EStructuralFeature)svc, startedResource, now, now);
    }

    public void shutDown() {
        this.defaultPackage.eResource().setURI(URI.createFileURI((String)Path.of(BASIC_BASE_ECORE, new String[0]).toAbsolutePath().toString()));
        try {
            this.defaultPackage.eResource().save(null);
            this.providers.values().forEach(this::saveInstance);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resourceSet.getResources().clear();
    }

    public void linkProviders(String parentProvider, String childProvider, Instant timestamp) {
        Instant metaTimestamp = timestamp == null ? Instant.now() : timestamp;
        NotificationAccumulator accumulator = this.notificationAccumulator.get();
        Provider parent = this.providers.get(parentProvider);
        Provider child = this.providers.get(childProvider);
        if (parent == null) {
            throw new IllegalArgumentException("No parent provider " + parentProvider);
        }
        if (child == null) {
            throw new IllegalArgumentException("No child provider " + childProvider);
        }
        parent.getLinkedProviders().add((Object)child);
    }

    public void unlinkProviders(String parentProvider, String childProvider, Instant timestamp) {
        Instant metaTimestamp = timestamp == null ? Instant.now() : timestamp;
        Provider parent = this.providers.get(parentProvider);
        Provider child = this.providers.get(childProvider);
        if (parent == null) {
            throw new IllegalArgumentException("No parent provider " + parentProvider);
        }
        if (child == null) {
            throw new IllegalArgumentException("No child provider " + childProvider);
        }
        parent.getLinkedProviders().remove((Object)child);
    }

    public void handleDataUpdate(String modelName, Provider provider, EStructuralFeature serviceFeature, EStructuralFeature resourceFeature, Object data, Instant timestamp) {
        EClassifier resourceType;
        Instant metaTimestamp = timestamp == null ? Instant.now() : timestamp;
        String providerName = provider.getId();
        NotificationAccumulator accumulator = this.notificationAccumulator.get();
        Service service = (Service)provider.eGet(serviceFeature);
        if (service == null) {
            service = (Service)EcoreUtil.create((EClass)((EClass)serviceFeature.getEType()));
            provider.eSet(serviceFeature, (Object)service);
            accumulator.addService(modelName, providerName, serviceFeature.getName());
        }
        ResourceMetadata metadata = (ResourceMetadata)service.getMetadata().get((Object)resourceFeature);
        Map<String, Object> oldMetaData = null;
        Object oldValue = service.eGet(resourceFeature);
        if (metadata != null) {
            oldMetaData = EMFCompareUtil.extractMetadataMap(oldValue, (Metadata)metadata, (ETypedElement)resourceFeature);
        }
        if (oldValue == null) {
            accumulator.addResource(modelName, providerName, serviceFeature.getName(), resourceFeature.getName());
        }
        if (metadata == null || !metadata.getTimestamp().isAfter(timestamp.plusMillis(1L))) {
            resourceType = resourceFeature.getEType();
            if (metadata == null) {
                metadata = MetadataFactory.eINSTANCE.createResourceMetadata();
                service.getMetadata().put((Object)resourceFeature, (Object)metadata);
            }
            metadata.setTimestamp(metaTimestamp);
            if (data == null || resourceType.isInstance(data)) {
                service.eSet(resourceFeature, data);
            } else {
                service.eSet(resourceFeature, EMFUtil.convertToTargetType(resourceType, data));
            }
        } else {
            return;
        }
        accumulator.resourceValueUpdate(modelName, providerName, serviceFeature.getName(), resourceFeature.getName(), resourceType.getInstanceClass(), oldValue, data, timestamp);
        if (metadata == null) {
            metadata = MetadataFactory.eINSTANCE.createResourceMetadata();
            service.getMetadata().put((Object)resourceFeature, (Object)metadata);
        }
        metadata.setTimestamp(timestamp);
        Map<String, Object> newMetaData = EMFCompareUtil.extractMetadataMap(data, (Metadata)metadata, (ETypedElement)resourceFeature);
        accumulator.metadataValueUpdate(modelName, providerName, serviceFeature.getName(), resourceFeature.getName(), oldMetaData, newMetaData, timestamp);
    }

    private Provider doCreateProvider(String modelName, EClass model, String providerName, Instant timestamp) {
        return this.doCreateProvider(modelName, model, providerName, timestamp, true);
    }

    private Provider doCreateProvider(String modelName, EClass model, String providerName, Instant timestamp, boolean createAdmin) {
        Provider provider = (Provider)EcoreUtil.create((EClass)model);
        provider.setId(providerName);
        this.notificationAccumulator.get().addProvider(modelName, providerName);
        if (createAdmin) {
            this.createAdminServiceForProvider(provider, timestamp);
        }
        this.providers.put(providerName, provider);
        return provider;
    }

    private void createAdminServiceForProvider(Provider original, Instant timestamp) {
        Provider provider = (Provider)EcoreUtil.copy((EObject)original);
        Admin adminSvc = ProviderFactory.eINSTANCE.createAdmin();
        provider.setAdmin(adminSvc);
        for (EStructuralFeature resourceFeature : provider.getAdmin().eClass().getEStructuralFeatures()) {
            if (resourceFeature != ProviderPackage.Literals.ADMIN__FRIENDLY_NAME && resourceFeature != ProviderPackage.Literals.ADMIN__MODEL_URI) continue;
            ResourceMetadata metadata = MetadataFactory.eINSTANCE.createResourceMetadata();
            metadata.setOriginalName(resourceFeature.getName());
            metadata.setTimestamp(timestamp);
            adminSvc.getMetadata().put((Object)resourceFeature, (Object)metadata);
        }
        adminSvc.setFriendlyName(provider.getId());
        adminSvc.setModelUri(EcoreUtil.getURI((EObject)provider.eClass()).toString());
        EMFCompareUtil.compareAndSet(provider, original, this.notificationAccumulator.get());
    }

    public Provider createProviderInstance(String modelName, String providerName) {
        return this.createProviderInstance(modelName, providerName, Instant.now());
    }

    public Provider createProviderInstance(String modelName, String providerName, Instant timestamp) {
        Provider provider = this.getProvider(providerName);
        if (provider != null) {
            String m = EMFUtil.getModelName(provider.eClass());
            if (!m.equals(modelName)) {
                throw new IllegalArgumentException("The provider " + providerName + " already exists with a different model " + m);
            }
            throw new IllegalArgumentException("The provider " + providerName + " already exists with the model " + modelName);
        }
        provider = this.doCreateProvider(modelName, this.getMandatoryModel(modelName), providerName, timestamp);
        return provider;
    }

    public Provider getProvider(String providerName) {
        return this.providers.get(providerName);
    }

    public String getProviderModel(String providerName) {
        return Optional.ofNullable(this.providers.get(providerName)).map(p -> EMFUtil.getModelName(p.eClass())).orElse(null);
    }

    public Provider getProvider(String model, String providerName) {
        String m;
        Provider p = this.providers.get(providerName);
        if (p != null && !(m = EMFUtil.getModelName(p.eClass())).equals(model)) {
            LOG.debug("Provider {} exists but with model {} not model {}", new Object[]{providerName, m, model});
            p = null;
        }
        return p;
    }

    public Collection<Provider> getProviders() {
        return Collections.unmodifiableCollection(this.providers.values());
    }

    public List<Provider> getProviders(String model) {
        EClass m = this.getMandatoryModel(model);
        return this.providers.values().stream().filter(p -> EMFUtil.getModelName(p.eClass()).equals(m)).collect(Collectors.toList());
    }

    public EAttribute createResource(EClass service, String resource, Class<?> type, Instant timestamp, Object defaultValue) {
        return this.createResource(service, resource, type, timestamp, defaultValue, false, 0L, false);
    }

    public EAttribute createResource(EClass service, String resource, Class<?> type, Instant timestamp, Object defaultValue, boolean hasGetter, long getterCacheMs, boolean hasSetter) {
        FeatureCustomMetadata resourceType = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
        resourceType.setName("resourceType");
        resourceType.setValue((Object)ResourceType.SENSOR);
        resourceType.setTimestamp(Instant.EPOCH);
        return this.doCreateResource(service, resource, type, timestamp, defaultValue, List.of(resourceType), hasGetter, getterCacheMs, hasSetter);
    }

    private EAttribute doCreateResource(EClass service, String resource, Class<?> type, Instant timestamp, Object defaultValue, List<FeatureCustomMetadata> metadata, boolean hasGetter, long getterCacheMs, boolean hasSetter) {
        this.assertResourceNotExist(service, resource);
        ResourceAttribute feature = EMFUtil.createResourceAttribute(service, resource, type, defaultValue);
        feature.setExternalGet(hasGetter);
        feature.setExternalSet(hasSetter);
        if (getterCacheMs > 0L) {
            feature.setExternalGetCacheMs(getterCacheMs);
        }
        EMFUtil.fillMetadata((NexusMetadata)feature, timestamp, false, resource, List.of());
        return feature;
    }

    private void assertResourceNotExist(EClass service, String resource) {
        ETypedElement element = service.getEOperations().stream().filter(o -> o.getName().equals(resource)).map(ETypedElement.class::cast).findFirst().orElseGet(() -> service.getEStructuralFeature(resource));
        if (element != null) {
            throw new IllegalArgumentException("There is an existing resource with name " + resource + " in service " + service + " in model " + EMFUtil.getModelName(service.eContainingFeature().getEContainingClass()));
        }
    }

    private EClass createModel(String modelName, String thePackageUri, Instant timestamp) {
        String modelClassName = this.firstToUpper(modelName);
        URI packageUri = URI.createURI((String)thePackageUri);
        EPackage ePackage = this.packageCache.get(packageUri);
        EClass model = EMFUtil.createEClass(modelClassName, ePackage, ec -> this.createEClassAnnotations(modelName, timestamp), ProviderPackage.Literals.PROVIDER);
        this.models.put(modelName, model);
        return model;
    }

    private EReference doCreateService(EClass model, String name, Instant timestamp) {
        EPackage ePackage = model.getEPackage();
        EClass service = EMFUtil.createEClass(this.constructServiceEClassName(model.getName(), name), ePackage, ec -> this.createEClassAnnotations(timestamp), ProviderPackage.Literals.SERVICE);
        ServiceReference ref = EMFUtil.createServiceReference(model, name, service, true);
        EMFUtil.fillMetadata((NexusMetadata)ref, timestamp, false, name, List.of());
        return ref;
    }

    private List<EAnnotation> createEClassAnnotations(Instant timestamp) {
        AnnotationMetadata meta = MetadataFactory.eINSTANCE.createAnnotationMetadata();
        meta.setTimestamp(timestamp);
        EAnnotation annotation = EMFUtil.createEAnnotation("metadata", Collections.singletonList(meta));
        return Collections.singletonList(annotation);
    }

    private List<EAnnotation> createEClassAnnotations(String model, Instant timestamp) {
        return List.of(this.createEClassAnnotations(timestamp).get(0), EMFUtil.createEAnnotation("model", Map.of("name", model)));
    }

    private String constructServiceEClassName(String providerName, String serviceName) {
        return this.firstToUpper(providerName) + this.firstToUpper(serviceName);
    }

    private String firstToUpper(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private void saveInstance(EObject p) {
        URI baseUri = URI.createFileURI((String)Path.of(INSTANCES, new String[0]).toAbsolutePath().toString());
        URI instanceUri = baseUri.appendSegment(EcoreUtil.getID((EObject)p)).appendFileExtension("xmi");
        Resource res = this.resourceSet.createResource(instanceUri);
        res.getContents().add((Object)p);
        try {
            p.eResource().save(Collections.singletonMap("SCHEMA_LOCATION", true));
        }
        catch (IOException ex) {
            LOG.error("THIS WILL BE A RUNTIME EXCPETION FOR NOW: Error saving provider fro URI: {}", (Object)instanceUri, (Object)p);
            throw new RuntimeException(ex);
        }
    }

    public Map<String, Object> getResourceMetadata(Provider provider, EStructuralFeature svcFeature, ETypedElement rcFeature) {
        Service svc = (Service)provider.eGet(svcFeature);
        if (svc == null) {
            return Map.of();
        }
        ResourceMetadata metadata = (ResourceMetadata)svc.getMetadata().get((Object)rcFeature);
        if (metadata == null) {
            return Map.of();
        }
        return this.toMetadataMap(rcFeature, metadata);
    }

    private Map<String, Object> toMetadataMap(ETypedElement rcFeature, ResourceMetadata metadata) {
        HashMap<String, Object> rcMeta = new HashMap<String, Object>();
        rcMeta.putAll(EMFUtil.toMetadataAttributesToMap((Metadata)metadata, rcFeature));
        return rcMeta;
    }

    public void setResourceMetadata(Provider provider, EStructuralFeature svcFeature, ETypedElement resource, String metadataKey, Object value, Instant timestamp) {
        ResourceMetadata metadata;
        if (metadataKey == null || metadataKey.isEmpty()) {
            throw new IllegalArgumentException("Empty metadata key");
        }
        if (timestamp == null) {
            throw new IllegalArgumentException("Invalid timestamp");
        }
        Service svc = (Service)provider.eGet(svcFeature);
        ResourceMetadata resourceMetadata = metadata = svc == null ? null : (ResourceMetadata)svc.getMetadata().get((Object)resource);
        if (metadata == null) {
            throw new IllegalStateException("No existing metadata for resource");
        }
        Map<String, Object> oldMetadata = this.toMetadataMap(resource, metadata);
        metadata.setTimestamp(timestamp);
        metadata.getExtra().stream().filter(fcm -> fcm.getName().equals(metadataKey)).findFirst().ifPresentOrElse(fcm -> this.handleFeatureCustomMetadata((FeatureCustomMetadata)fcm, metadataKey, timestamp, value), () -> metadata.getExtra().add((Object)this.handleFeatureCustomMetadata(ProviderFactory.eINSTANCE.createFeatureCustomMetadata(), metadataKey, timestamp, value)));
        Map<String, Object> newMetadata = this.toMetadataMap(resource, metadata);
        this.notificationAccumulator.get().metadataValueUpdate(EMFUtil.getModelName(provider.eClass()), provider.getId(), svcFeature.getName(), resource.getName(), oldMetadata, newMetadata, timestamp);
    }

    private FeatureCustomMetadata handleFeatureCustomMetadata(FeatureCustomMetadata customMetadata, String metadataKey, Instant timestamp, Object value) {
        customMetadata.setName(metadataKey);
        customMetadata.setTimestamp(timestamp);
        customMetadata.setValue(value);
        return customMetadata;
    }

    public Set<String> getModelNames() {
        return Set.copyOf(this.models.keySet());
    }

    public Optional<EClass> getModel(String modelName) {
        return Optional.ofNullable(this.models.get(modelName));
    }

    public boolean registered(EClass eClass) {
        return this.models.containsValue(eClass);
    }

    private EClass getMandatoryModel(String modelName) {
        return this.getModel(modelName).orElseThrow(() -> new IllegalArgumentException("No model with name " + modelName));
    }

    public EClass createModel(String modelName, Instant timestamp) {
        if (this.getModel(modelName).isPresent()) {
            throw new IllegalArgumentException("There is an existing model with name " + modelName);
        }
        return this.createModel(modelName, DEFAULT_URI, timestamp);
    }

    public EReference createService(EClass model, String service, Instant creationTimestamp) {
        if (model.getEStructuralFeature(service) != null) {
            throw new IllegalArgumentException("There is an existing service with name " + service + " in model " + model);
        }
        return this.doCreateService(model, service, creationTimestamp);
    }

    public Stream<EReference> getServicesForModel(EClass model) {
        EClass svcClass = ProviderPackage.Literals.SERVICE;
        return model.getEAllReferences().stream().filter(r -> svcClass.isSuperTypeOf(r.getEReferenceType()));
    }

    private EReference getServiceForModel(EClass model, String serviceName) {
        EStructuralFeature feature = model.getEStructuralFeature(serviceName);
        EClass serviceEClass = ProviderPackage.Literals.SERVICE;
        if (!(feature == null || feature instanceof EReference && serviceEClass.isSuperTypeOf(((EReference)feature).getEReferenceType()))) {
            throw new IllegalArgumentException("The field " + serviceName + " exists in the model " + EMFUtil.getModelName(model) + " and is not a service");
        }
        return feature == null ? null : (EReference)feature;
    }

    public Stream<ETypedElement> getResourcesForService(EClass svcClass) {
        return Stream.concat(svcClass.getEAllAttributes().stream().filter(o -> o.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE), svcClass.getEAllOperations().stream().filter(o -> o.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(Predicate.not(ProviderPackage.Literals.SERVICE___EIS_SET__ESTRUCTURALFEATURE::equals)));
    }

    public EOperation createActionResource(EClass serviceEClass, String name, Class<?> type, List<Map.Entry<String, Class<?>>> namedParameterTypes) {
        this.assertResourceNotExist(serviceEClass, name);
        List<ActionParameter> params = namedParameterTypes.stream().map(EMFUtil::createActionParameter).collect(Collectors.toList());
        Action action = EMFUtil.createAction(serviceEClass, name, type, params);
        return action;
    }

    public Promise<Object> act(Provider provider, EStructuralFeature service, ETypedElement resource, Map<String, Object> parameters) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to act on a value without an action handler"));
        }
        try {
            return this.whiteboard.act(EMFUtil.getModelName(provider.eClass()), provider.getId(), service.getName(), resource.getName(), parameters);
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public <T> Promise<TimedValue<T>> pullValue(Provider provider, EStructuralFeature service, ETypedElement resource, Class<T> valueType, TimedValue<T> cachedValue) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to pull a value without a pull handler"));
        }
        try {
            String modelName = EMFUtil.getModelName(provider.eClass());
            return this.whiteboard.pullValue(modelName, provider.getId(), service.getName(), resource.getName(), valueType, cachedValue, tv -> {
                if (tv != null) {
                    this.handleDataUpdate(modelName, provider, service, (EStructuralFeature)resource, tv.getValue(), tv.getTimestamp());
                }
            });
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public <T> Promise<TimedValue<T>> pushValue(Provider provider, EStructuralFeature service, ETypedElement resource, Class<T> valueType, TimedValue<T> cachedValue, TimedValue<T> newValue) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to push a value without a push handler"));
        }
        try {
            String modelName = EMFUtil.getModelName(provider.eClass());
            return this.whiteboard.pushValue(modelName, provider.getId(), service.getName(), resource.getName(), valueType, cachedValue, newValue, tv -> {
                if (tv != null) {
                    this.handleDataUpdate(modelName, provider, service, (EStructuralFeature)resource, tv.getValue(), tv.getTimestamp());
                }
            });
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public void deleteProvider(String model, String name) {
        String m = this.getProviderModel(name);
        if (m != null) {
            if (m.equals(model)) {
                this.providers.remove(name);
                this.notificationAccumulator.get().removeProvider(model, name);
            } else {
                LOG.warn("Unable to remove the provider {} with model {} as the actual model was {}", new Object[]{name, model, m});
            }
        } else {
            LOG.info("The provider {} does not exist and cannot be removed", (Object)name);
        }
    }

    public Provider save(Provider eObject) {
        String id = EMFUtil.getProviderName((EObject)eObject);
        Provider original = this.providers.get(id);
        if (original == null) {
            original = this.doCreateProvider(EMFUtil.getModelName(eObject.eClass()), eObject.eClass(), id, Instant.now(), eObject.getAdmin() == null);
        }
        EMFCompareUtil.compareAndSet(eObject, original, this.notificationAccumulator.get());
        return (Provider)EcoreUtil.copy((EObject)original);
    }

    public Provider getProvider(EClass model, String id) {
        Provider provider = this.providers.get(id);
        if (provider.eClass() != model) {
            throw new IllegalArgumentException("Provider " + id + " does not have the same model expected " + EMFUtil.getModelName(model) + ", but provider is " + EMFUtil.getModelName(provider.eClass()));
        }
        return provider;
    }

    public EClass registerModel(EClass modelEClass, Instant timestamp) {
        if (this.registered(modelEClass)) {
            throw new IllegalArgumentException("There is an existing model with name " + EMFUtil.getModelName(modelEClass));
        }
        this.models.put(EMFUtil.getModelName(modelEClass), modelEClass);
        return null;
    }

    public void addEPackage(EPackage ePackage) {
        if (ePackage != this.providerPackage) {
            ePackage.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(arg_0 -> ((EClass)ProviderPackage.Literals.PROVIDER).isSuperTypeOf(arg_0)).forEach(ec -> this.models.put(EcoreUtil.getURI((EObject)ec).toString(), (EClass)ec));
        }
    }

    public void removeEPackage(EPackage ePackage) {
        if (ePackage != this.providerPackage) {
            ePackage.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(arg_0 -> ((EClass)ProviderPackage.Literals.PROVIDER).isSuperTypeOf(arg_0)).forEach(ec -> this.models.remove(EcoreUtil.getURI((EObject)ec).toString()));
        }
    }
}

